filename = 'F:\APT\R14_18974\recons\recon-v02\default\R14_18974-v02.pos';
%filename = 'F:\APT\R14_18959\recons\recon-v01\default\R14_18959-v01.pos';
sampleFileFraction = 0.1; % only read this fraction of the data
chunkSize = 100;
edgeAngle = 10; % number of edge points
% read file
%[x,y,z,m,nb]=readpos(filename);
fileInfo = dir(filename);
fileSize = fileInfo.bytes;
n = fileSize/16;
[x,y,z,m,nb]=readposN(filename,round(n*sampleFileFraction));
x=x';y=y';z=z';
chunks = ceil(nb/chunkSize);
results = zeros(chunks-1,6);

for i=1:(chunks-1)
    % sphere fitting
    
    a = (((i-1)*chunkSize)+1):(i*chunkSize + 1);
    X = x(a); Y=y(a); Z=z(a);
    [results(i,1:3),results(i,4)]=sphereFit([X; Y; Z]');
    % find edges
    [~,rho,~]=cart2sph(X,Y,Z-results(i,3));
    rho = 180*rho/pi+90;
    maxRho = max(rho);
    results(i,5) = maxRho; % angle
    results(i,6) = range(Z(rho<edgeAngle));
end

