function [rangeFileList,posFileList] = rpvLs(range,ver,add,root)
%[rangeFileList,posFileList] = rpvLs(range,(ver),(add),(root))
% rpvLs: takes a list of ranges names (minus .rrng), version, additional folder args
% returns the paths of the range files and pos files.
% Assumes range = run number!
% You can also specify a root, eg C:\APT if you wish
% This assumes the standard IVAS folder system:
% #ROOT\R14_#RANGE#ADD\recons\recon-v0#VER\default\R14_#RANGE-v0#VER.pos

if nargin < 1
  error('Range list required')
end
if nargin < 2
  ver = cell(size(range));
  ver(:,:) = {'1'}; % assume recon version 1
end
if nargin < 3
  add = cell(size(range));
  add(:,:) = {''}; % assume no additional folder parts
end
if nargin < 4
  root = 'C:\Users\andy\APT\';
end

posFileList = cell(length(range),1);

% make pos file list
for i = 1:length(range)
    %disp(i);
    trialName = strcat(root,'R14_',range{i},add{i},'\recons\recon-v0',...
        num2str(ver{i}),'\default\R14_',range{i},'-v0', num2str(ver{i}),'.pos');
    if(exist(trialName,'file'))
        % Check for file
        posFileList{i} = trialName;
    else
        disp(strcat('Could not find file_',trialName));
    end
end
%rangeFileList = strcat(root,range);
% or 
rangeFileList = strcat(root,range,'.rrng');
end