% round robin deconvolution and composition
posFiles = {'F:\APT\RoundRobin\R15_00554\recons\recon-v01\default\R15_00554-v01.pos',...
    'F:\APT\RoundRobin\R38_01732\recons\recon-v01\default\R38_01732-v01.pos'};

%rangeVet3 to generate iList:
iList = {'Al','33FFFF','0.01661',2;'As','CC00CC','0.02150',2;'C','660033','0.00878',[1,2];'C2','660033','0.01757',1;'Co','0000FF','0.01108',2;'Cr','FF33CC','0.01201',2;'Cu','FF6600','0.01181',[1,2];'Fe','FF00FF','0.01177',[1,2];'Mn','CCCC00','0.01221',[1,2];'Mo','FF0033','0.01558',2;'Ni','00CC00','0.01094',[1,2];'O','FF0000','0.02883',1;'P','FF00FF','0.02826',[1,2,3];'Si','CCCCCC','0.02003',2;'Sn','00CC00','0.02705',2;'V','CC00CC','0.01382',2;};

% which using rangeSynthetic makes overlapIons:
%[newR,overlapIons,ionR]=rangeSynthetic('F:\APT\RoundRobin\38_01732.rrng',iList,'s');
overlapIons2 = {{{1,'C',2;},{2,'Cr',1;},{2,'Fe',1;},{2,'Ni',1;},...
    {1,'P',1;},{2,'V',1;}};{{1,'Fe',1;},{1,'Ni',1;},{2,'Sn',1;}};};
overlapIons3 = {{{1,'C',2;},{2,'Cr',1;},{2,'Fe',1;},{2,'Ni',1;},...
    {1,'P',1;},{2,'V',1;}};{{1,'Fe',1;},{1,'Ni',1;}};};
% optimise range files
rangeCorrector3('F:\APT\RoundRobin\15_00554ss.rrng',posFiles{1},0.8);
rangeCorrector3('F:\APT\RoundRobin\38_01732ss.rrng',posFiles{2},0.8);
rangeFiles = {'F:\APT\RoundRobin\15_00554ss_80.rrng','F:\APT\RoundRobin\38_01732ss_80.rrng'};
% which can be used in the decomposition
[deconvCounts1,asRangedCounts1,rangeOutput1,rangeTableDecomp1]=massDecomp(rangeFiles{1},posFiles{1},overlapIons3);
[deconvCounts2,asRangedCounts2,rangeOutput2,rangeTableDecomp2]=massDecomp(rangeFiles{2},posFiles{2},overlapIons2);

% results
a=[rangeOutput1 num2cell(100*deconvCounts1./sum(deconvCounts1))'];
b=[rangeOutput2 num2cell(100*deconvCounts2./sum(deconvCounts2))'];