function [rotatedPos] = rotatePos(posFile,theta)
%[rotatedPos] = rotatePos(posFile,angle)
%Rotates a pos file by the specified number of degrees clockwise about the
%Z-axis (vertical)
%% Open file
[x,y,z,m,nb]=readpos(posFile);
size(x)
%% Rotate
R = [cosd(theta) -sind(theta); sind(theta) cosd(theta)];
v = [x' y'];
vR = v*R;
%% Save file
rotatedPos = strcat(posFile,'_rotated',num2str(theta));
savepos(vR(:,1),vR(:,2),z,m,rotatedPos);
end