function ionicComp = returnOverlaps(targetIon,targetRange,ionicRangeTables, ions)
%ionicComp = returnOverlaps(targetIon,targetRange,ionicRangeTables, ions)
% with a given target ion (str) and a particular target range (in Da), find the ionic
% composition of that ion in that range from an ionicRangeTable (such as
% that produced by clusterDecompTablesIonic)
% you can send this function a cell array of ionicRangeTables and it will
% return the ionicComp for each of the rangeTables
if iscell(ionicRangeTables)
    count = length(ionicRangeTables);
    ionicComp = zeros(count,1);
    % find target ion in ions, if not found ionicComp = 0
    ionPos = strcmp(targetIon,ions);
    if sum(ionPos)==0
        disp([targetIon ' not found']);
    else
        for c=1:count
            % find range
            rngs = (ionicRangeTables{c}(:,1)<targetRange & ionicRangeTables{c}(:,2)>targetRange);
            % assign composition
            if sum(rngs)
                ionicComp(c) = ionicRangeTables{c}(rngs,logical([0 0 ionPos]));
            else
                ionicComp(c) = 0;
            end
        end
    end
else % assume just a single ionic range table
    count = 1;
    ionicComp = zeros(count,1);
    % find target ion in ions, if not found ionicComp = 0
    ionPos = strcmp(targetIon,ions);
    if sum(ionPos)==0
        disp([targetIon ' not found']);
    else
        rngs = (ionicRangeTables(:,1)<targetRange & ionicRangeTables(:,2)>targetRange);
        % assign composition
        if sum(rngs)
            ionicComp = ionicRangeTables(rngs,ionPos+2);
        end
    end
end