% save reflections to a list that can be plotted on XRD data in R

% get reflection list files:
root = 'C:\Users\andy\Documents\crystals\';
f = dir([root '*.txt']);
files = {f.name}';

export1 = cell(length(files),1);
for i=1:length(files)
    [reflexions,header,formla,labels,textName] = importReflectionsList([root files{i}]);
    export1{i} = [reflexions(:,5) labels cellstr(repmat(textName,length(labels),1)) reflexions(:,7)];
end
header = {'x','label','name','I'}; 
export = [header; vertcat(export1{:})];

cell2csv('reflectionsList.csv',export);

%% additional file with different threshold:
% i = i + 1;
%[reflexions,header,formla,labels,textName] = importReflectionsList('C:\Users\andy\Documents\crystals\62671-Cr16Fe7C6 Reflexions.txt',5);
% export1{i} = [reflexions(:,5) labels cellstr(repmat(textName,length(labels),1)) reflexions(:,7)];
% header = {'x','label','name','I'};
% export = [header; vertcat(export1{:})];
% cell2csv('reflectionsListCr.csv',export);