function [m]=readpospartm(file_name,n0,n1)
% function [x,y,m,z,M,sdm]=readpospartm(file_name,n0,n1)
% Reads mass data from a .pos file (4 floats-big endian) from atom n0 to n1
% and extract 1 matrix of m/z, returns column-wise list (1 x n)
% DO NOT USE, it is faster (roughly x3) to use [~,~,~,m]=readpospart but
% this will use x4 the amount of memory - so if you are reading masses and
% memory is an issue then you can use readpospartm

%% opens the file
fid = fopen(file_name, 'r');
disp('pos file is being read...');
%% Moves the pointer to n0
fseek(fid,4*4*(n0-1) + 12,0);
%% Reads through the file made of 4 floats
% read 1 float then skip 3 (12 bytes)
m=fread(fid, 1*(n1-n0+1), '1*float32', 12, 'b')';
% %% Makes an array with the list of floats
% nb=length(lflo);
% flo=reshape(lflo, [1 nb]);
% clear lflo
% %% Creates output
% m=flo(1,:);
%% Closes the file
fclose(fid);
disp('OK, file read, variables created.');

