function [x,y,z,m]=readpospart(file_name,n0,n1)
% function [x,y,m,z,M,sdm]=readpos(file_name, reso)
% Reads data from a .pos file (4 floats-big endian) from atom n0 to n1
% and extract 4 matrixes with x,y,z and m

%% opens the file
fid = fopen(file_name, 'r');
disp('pos file is being read...');
%% Moves the pointer to n0
fseek(fid,4*4*(n0-1),0);
%% Reads through the file made of 4 floats
lflo=fread(fid, 4*(n1-n0+1), '4*float32', 'b');
%% Makes an array with the list of floats
nb=length(lflo)/4;
flo=reshape(lflo, [4 nb]);
clear lflo
%% Creates output
x=flo(1,:);
y=flo(2,:);
z=flo(3,:);
m=flo(4,:);
%% Closes the file
fclose(fid);
disp('OK, file read, variables created.');

