function m=readpos_mass(fileName)
%m=readpos_mass(nom_fichier)
% Script to read mass from .pos files
% useage masses = readpos('fileName')
% this returns, for each ion, the m/z ratio
% Original E. Marquis, modified A. London Oct 2012

name = regexprep(fileName,'\.pos',''); % removes possible extention
fix='.pos';
name=strcat(name,fix); % adds file extention
[fid,msg] = fopen(name, 'r');
if fid==-1 % error checking
    disp('error');
    error([msg ' ' name]);
end
disp('Reading pos file...');
% fseek( fid, 12, 'bof' ) ;
% m=fread(fid, [1,inf], '*float32', 12, 'b');
lflo=fread(fid, [4,inf], '*float32', 'b');
m = lflo(4,:);
clear lflo
fclose(fid);
disp(strcat('OK, finished reading:',fileName,':',num2str(length(m)),' ions'));
end