function [x,y,z,m,nb]=readposOLD(nom_fichier)
%[x,y,z,m,nb]=readpos(nom_fichier)
% function to read .pos files
% useage [x,y,z,m,nb]=readpos('fileName')
% this returns, for each ion, the x,y,z postion
% m/z ratio and multiple hit identity
% Original E. Marquis, modified A. London Oct 2012
name = regexprep(nom_fichier,'\.pos',''); % removes possible extention
fix='.pos';
name=strcat(name,fix); % adds file extention
[fid,msg] = fopen(name, 'r');
if fid==-1 % error checking
    disp('error');
    error([msg ' ' name]);
end
disp('Reading pos file...');

lflo=fread(fid, inf, '4*float32', 'b');
length(lflo);
nb=length(lflo)/4;
flo=reshape(lflo,[4 nb]);

x=flo(1,:);
y=flo(2,:);
z=flo(3,:);
m=flo(4,:);

fclose(fid);
disp(strcat('OK, finished reading:',nom_fichier,':',num2str(nb),' ions'));

end