function [x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos(filename)
% Script to read .epos files, useage [x,y,z,m,tof,vdc,vp,xd,yd,dP,nm,nb]=readepos('fileName')
% this returns, for each ion, the x,y,z postion
% m/z ratio and other data
% A. London March 2013

% x Reconstructed position along the x-axis (nm)
% y Reconstructed position along the y-axis (nm)
% z Reconstructed position along the z-axis (nm)
% m/n Reconstructed mass-to-charge-state ratio (Da)
% TOF Raw time-of-flight (ns)
% VDC Standing voltage (V)
% VP Pulsed voltage (V). For laser runs, this is zero
% XDET Ion impact x-coordinate at the detector (mm)
% YDET Ion impact y-coordinate at the detector (mm)
% DP Number of pulses since the last detected ion (pulses)
% For multi-hit records, after the first record, this is zero
% NM Hit multiplicity (ions)
% For multi-hit records, after the first record, this is zero
% nb is the total number of hits

%fix='.epos';
%name=strcat(filename,fix);
name=filename;
if ~exist(name,'file');
   error(strcat('File:',name,' not found!')); 
end
% Thanks to: http://stackoverflow.com/questions/8096702/reading-multiple-precision-binary-files-through-fread-in-matlab
%# type and size in byte of the record fields
recordType = {'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'float32' 'uint32' 'uint32'};
recordLen = [4 4 4 4 4 4 4 4 4 4 4];
R = cell(1,numel(recordType));

fid = fopen(name, 'r','b');
disp('Reading pos file...');

%# read column-by-column
for i=1:numel(recordType)
    %# seek to the first field of the first record
    fseek(fid, sum(recordLen(1:i-1)), 'bof');

    %# % read column with specified format, skipping required number of bytes
    R{i} = fread(fid, inf, ['*' recordType{i}], sum(recordLen)-recordLen(i));
end

x=R{1};
y=R{2};
z=R{3};
m=R{4};
tof=R{5};
vdc=R{6};
vp=R{7};
xd=R{8};
yd=R{9};
dP=R{10};
nm=R{11};
nb = length(x);
fclose(fid);
disp('OK, finished reading file.');
end