function [eposData] = readCachedEpos(eposFile,flag)
% [eposData] = reachCahcedEpos(eposFile,flag)
% This function reads epos files cached using eposCache.
% The eposFile should have no extension.
% The value of flag reads either:
% [0] [x,y,z,m,nm,vdc] % positions, mass, multiple hit, standing voltage
% [1] [xd,yd,dP,tof] % dectorXY, d(pulse number), raw Time of flight
% [2] [x,y,z,m,nm,vdc,xd,yd,dP,tof] % all in this order
% Reutrns eposData structure:
% x=eposData(:,1); for example
switch flag
    case 0
        vcfile = strcat(eposFile,'_Vc.mat');
        if exist(vcfile,'file')
            load(vcfile);
            eposData=[x y z m single(nm) vdc];
            disp('eposData=[x y z m nm vdc]');
        else
            error(strcat('No cached file:',vcfile,' found. Please use eposCacheSave first'));
        end
    case 1
        dfile = strcat(eposFile,'_d.mat');
        if exist(dfile,'file')
            load(dfile);
            eposData=[xd yd single(dP) tof];
            disp('eposData=[xd yd dP tof]');
        else
            error(strcat('No cached file:',dfile,' found. Please use eposCacheSave first'));
        end
    case 2
        vcfile = strcat(eposFile,'_Vc.mat');
        if exist(vcfile,'file')
            load(vcfile);
            dfile = strcat(eposFile,'_d.mat');
            if exist(dfile,'file')
                load(dfile);
                eposData=[x y z m single(nm) vdc xd yd single(dP) tof];
                disp('eposData=[x,y,z,m,nm,vdc,xd,yd,dP,tof]');
            else
                error(strcat('No cached file:',dfile,' found. Please use eposCacheSave first'));
            end
        else
            error(strcat('No cached file:',vcfile,' found. Please use eposCacheSave first'));
        end
    otherwise
        error('Invalid flag provided, flag should be 0,1, or 2');
end
end