function [chargeState,textIonList] = ranges2chargeState(rangeTable,elements,TeX_symbols)
% [chargeState] = ranges2chargeState(ranges,elements,TeX_symbols)
% returns a list of chargeStates, one for each range.
% ranges is a RxM matrix [lower upper 0 0 0 0 1; etc] and elements is cell
% array of elements {'Fe','Ti','O', etc} length (M-2)
% You can generate ranges like so:
% [~, ~, elements, ranges] = rangeReader ('rangeFile.rrng');
% ranges = cell2mat(ranges(:,[1:2 5:end]));
% TeX_symbols = 0; % use superscript and subscript labels? 0 = false

if iscell(rangeTable)
    error('rangeTable was type cell, should be type double');
end

% read isotopes file - required file
if(exist('isotopes.mat','file'))
    isotopes = open('isotopes.mat');
    isotopes = isotopes.isotopes;
else
    disp('isotopes.mat file not found!');
end

if TeX_symbols
    ss = '_';
    sS = '^';
else
    ss='';
    sS='';
end



ranges = num2cell(rangeTable);
extraCols = 2;
chargeState = zeros(size(rangeTable,1),1);
textIonList = cell(size(rangeTable,1),1);
for r = 1:size(rangeTable,1)
    % get ion name
    textIon = '';
    mass = 0;
    for e=1:size(elements,1)
        if(ranges{r,extraCols+e}>0)
            textIon = strcat(textIon,elements{e});
            index = find(not(cellfun('isempty', strfind(isotopes(:,1),strcat(elements{e},'(')))));
            mass = mass + isotopes{index(1),2}*ranges{r,extraCols+e};
            if(ranges{r,extraCols+e}>1)
                textIon = strcat(textIon,ss,num2str(ranges{r,extraCols+e}));
            end
        end
    end
    rangeCentre = (ranges{r,1}+ranges{r,2})/2;
    chargeState(r) = round(mass/rangeCentre);
    for i=1:chargeState(r)
        textIon = strcat(textIon,sS,'+');
    end
    textIonList{r} = textIon;
end
