% Reads a batch of rrng files, identifies TiO++ ranges and renames them
% This is the first stage before a cluster search using these ranges
% to deconvolve the 32 peak into TiO++ and O2+

% get all the range files in APT/peak32
rootdir= 'C:/Users/andy/APT/peak32/';
rrng_files = dir(fullfile(rootdir,'*.rrng'));
num_files = length(rrng_files);

% TiO++ peaks are:
masses = [30.973774	31.47334 31.971431 32.471393 32.9698505]; % ideal centres of the ranges to be relabelled
names = {'Am' 'Bk' 'Cm' 'Dy' 'Er'}; % new names for the ranges
targetElements = {'Ti' 'O'}; % Elements in the target ion
targetIonStoy = [1, 1]; % TiO2 => [1, 2]; not yet implamented, see 'check'

for f = 1:num_files
    % range read
    rangeFile = fullfile(rootdir,rrng_files(f).name);
    
    % read rrng file
    [element_num, range_num, elements, ranges] = rangeReader (rangeFile);
    % pad the range file to add in the extra elements
    ranges(:,end+1:end+length(masses)) = num2cell(zeros(range_num,length(masses)));
    % add in the new elements tp the elements array
    elements = [elements; names'];
    
    
    % identify target element positions
    % position of the target elements in 'elements' array
    targetEpos = zeros(1,length(targetElements));
    targetRanges = zeros(1,length(masses));
    for t = 1:length(targetElements)
        idxC = strfind(elements,targetElements{t});
        targetEpos(t) =  find(not(cellfun('isempty', idxC)));
    end
    % shift target element position by 4 (to account for ranges, colours
    % etc)
    targetEpos = targetEpos + 4;
    % identify TiO++ peaks in this range file
    for r = 1:range_num
        for m = 1:length(masses)
            if masses(m)>ranges{r,1} && masses(m)<ranges{r,2}
                % in the right mass range
                % check ion identity
                check = 1;
                for c = 1:length(targetEpos)
                    check = check * ranges{r,targetEpos(c)};
                    % this checks there is at least one of each element
                    % from targetElements in this ion
                    % does this by multiplication, if  0, check -> 0
                    % could be more specific (eg TiO not TiO_2)
                end
                % if check passed, not equal 0:
                if(check)
                    disp(strcat('Renaming range: ',num2str(ranges{r,1}) ...
                       , '-' ,num2str(ranges{r,2}),' to:',names(m)));
                    targetRanges(m) = r;
                    % remove target element entries (set to zero)
                    for c = 1:length(targetEpos)
                        ranges{r,targetEpos(c)} = 0;
                    end
                    % set new element-ion matrix entry to 1
                    ranges{r,4+element_num+m} = 1;
                end
            end
        end
    end
    element_num = length(elements);
    % write out new range file
    if(1)
        % separate rangeFile name
        [pathstr, name, ext] = fileparts(rangeFile);
        % change name
        name = strcat(name,'pk32');
        % new name and path
        newName = fullfile(pathstr,name); 
        % NB: no extension needed for rangeWriter
        
        % write range file
        newRrng = rangeWriter(ranges,elements,newName);
        
        disp(strcat('Wrote new rrng file:',newRrng));
    end
end