function [newFile] = rangeWriter( ranges, elements, rangeFile )
%[newFile] = rangeWriter( ranges, elements, rangeFile )
%rangeWriter: Writes a rrng range file
%   Takes a ranges cell array in the format:
% 1          2        3   4      5            4+element_num
% rangeStart rangeEnd vol colour element1 ... elementN
% and a elements cell array in the format = {'Fe' 'Cr' 'Y' etc}
% Writes output to rangeFile.rrng

% get file name, without extension
disp(strcat('Writing new rrng file:',rangeFile,'.rrng'));

% open a new file: name_level.rrng
fid = fopen(strcat(rangeFile,'.rrng'), 'w');

if fid ==-1
    fclose(fid);
    error(strcat('Cannot create new rrng file with name:',rangeFile,'.rrng'));
end

element_num = length(elements);
fprintf(fid,'[Ions]\nNumber=%d\n',element_num);

for e=1:element_num
    fprintf(fid,'Ion%d=%s\n',e,elements{e});
end

range_num = length(ranges(:,1));
fprintf(fid,'[Ranges]\nNumber=%d\n',range_num);

% variable used else where, number of columns before element matrix
extraCols = 4;

for r=1:range_num
    fprintf(fid,'Range%d=%6.4f %6.4f Vol:%f ',r,ranges{r,1},ranges{r,2}, ranges{r,3});
    for e=1:element_num
        if(ranges{r,extraCols+e}>0)
            fprintf(fid,'%s:%d ',elements{e},ranges{r,extraCols+e});
        end
    end
    fprintf(fid,'Color:%s\n',ranges{r,4});
end

fclose(fid);
newFile = strcat(rangeFile,'.rrng');
end

