% range vetting
% this collects all the range files from a dir and tabulates the ions and
% the rounded centres of their range:
% Centre    rrng1   rrng2 ...
% 6.0       C       C
% 12.0      -       C2
% Writes to 'rangeSummary.xls'
% A London April 2013

% plan:
% get range files
% read range files
% loop through ranges making a list:
%a) rounded to 0.1 and centred m/z value
%b) Ion ranged
%c) Name
% Put the above into the summary table above
% Write out to xls file.

maxRangeMz = 250; % maximum mass:charge ratio
binWidth = 0.1; %what the ranges are rounded to
start = 5; % minimum mass:charge ratio

addy = 'F:\APT\RoundRobin\'; % get file location C:\ etc..
mat = {'a','a','a'};
%addy ='C:\Users\andy\Documents\MATLAB\';

filelist =  dir([fileparts(addy) filesep '*.rrng']); % get all rrng files
fileNames = strcat(addy,{filelist.name}');
shortNames = {filelist.name}';
%[d,cols]=dataBase('run>0',1);
%idCol = strcmp('run',cols);
% get the run id from the range file, assumes range name = run+extra.rrng
runFromRrng = cell2mat(cellfun(@str2double,regexp(fileNames,'\d\d\d\d\d','match'),'uni',0));
%dataPosition = cellfun(@(x)find(cell2mat(d(:,idCol))==x),(cellfun(@str2double,regexp(fileNames,'\d\d\d\d\d','match'),'uni',0)),'uni',0);
%mat = d(cell2mat(dataPosition),strcmp('mat',cols));
summary = cell(round((maxRangeMz-start)/binWidth)+1,length(fileNames)+1);
summary(:,1) = num2cell(round((start:binWidth:maxRangeMz)*(1/binWidth))*binWidth);
rangeLim1 = cell(round((maxRangeMz-start)/binWidth)+1,length(fileNames));
rangeLim2 = rangeLim1;
% ion colour vol list
ionColVol = cell(length(fileNames),1); % unknown size

for currentFile = 1:length(fileNames)
    % read range file
    [element_num, range_num, elements, ranges] = rangeReader (fileNames{currentFile});
    chargeState = round(rangeMass(cell2mat(ranges(:,5:end)),elements)./mean(cell2mat(ranges(:,1:2)),2));
    % add ions to ionColVol list
    %     if currentFile == 1 % initialise ionColVol
    %         ionColVol = [makeIon(cell2mat(ranges(:,5:end)),elements)' ranges(:,3:4) chargeState];
    %     else
    %         ionColVol = [ionColVol; makeIon(cell2mat(ranges(:,5:end)),elements)' ranges(:,3:4) chargeState];
    %     end
    ionColVol{currentFile} = [makeIon(cell2mat(ranges(:,5:end)),elements)' ranges(:,3:4) num2cell(chargeState)];
    %iList = makeIon(cell2mat(ranges(:,5:end)),elements);
    cvList = ranges(:,3:4);
    % loop through ranges
    for r = 1:range_num
        % rounded centred range
        rc = round(((ranges{r,1}+ranges{r,2})/2)*(1/binWidth))*binWidth;
        % find row number to add ion to
        if(rc >= start)
            if(rc <= maxRangeMz)
                row = round((rc-start)/binWidth);
                % assign ion
                ion = makeIon(cell2mat(ranges(r,5:end)),elements);
                summary{row,currentFile+1} = ion{1};
                rangeLim1{row,currentFile} = ranges{r,1};
                rangeLim2{row,currentFile} = ranges{r,2};
            else
                disp(strcat('Range:',num2str(rc),' too large, increase max m/z'));
            end
        else
            disp(strcat('Range:',num2str(rc),' too small, decrease min m/z'));
        end
    end
end
% remove empty rows
for i = length(summary(:,1)):-1:1
    if(i<=length(summary(:,1)))
        % get the ion row, strcat the ions together, sum char values
        if ~sum(char(strcat(summary{i,2:end})))
            %disp(strcat('Removing row:',num2str(i)));
            summary(i,:) = [];
            %i = i - 2;
        end
    end
end
ionColVol = vertcat(ionColVol{:});
iList = unique(ionColVol(:,1)); % list of ions
% sort through ionColVol list
for i=1:length(iList)
    colours = ionColVol(strcmp(ionColVol(:,1),iList(i,1)),3);
    [~,c]=cellhist(colours);
    vols = cellfun(@(x)sprintf('%6.5f',x),ionColVol(strcmp(ionColVol(:,1),iList(i,1)),2),'uni',0);
    [~,v]=cellhist(vols);
    iList(i,2:3) = [c(1) v(1)];
    % possible charge states:
    iList{i,4} = unique(cell2mat(ionColVol(strcmp(iList{i,1},ionColVol(:,1)),4)))';
end
% edit colours
iList = editColours(iList);
rangeLim1 = rangeLim1(sum(~cell2mat(cellfun(@isempty,rangeLim1,'uni',0)),2)>0,:);
rangeLim2 = rangeLim2(sum(~cell2mat(cellfun(@isempty,rangeLim2,'uni',0)),2)>0,:);
rangeLim1(cell2mat(cellfun(@isempty,rangeLim1,'uni',0))) = {NaN};
rangeLim2(cell2mat(cellfun(@isempty,rangeLim2,'uni',0))) = {NaN};
% per mat code
[uniqueMats,ia,ic]=unique(mat); % make unique list of mat codes
rangeLimMean = zeros(size(rangeLim1,1),length(uniqueMats)*2);
modeIons = cell(1,length(uniqueMats));
for j = 1:length(uniqueMats)
    c = (ic==j);
    rangeLimMean(:,[j*2-1 j*2]) = [nanmean(cell2mat(rangeLim1(:,c)),2) nanmean(cell2mat(rangeLim2(:,c)),2)];
    % modal ion:
    a = cellfun(@(x)find(strcmp(x,iList(:,1)),1),summary(:,logical([0 c'])),'uni',0);
    %summary(:,logical([0 c'])) because we need to eclude the first col of
    %summary
    a(cellfun(@isempty,a))={nan}; % nan empty cells
    a = mode(cell2mat(a),2);
    p = ~isnan(a);
    modeIons{j} = [iList(a(p),1:3) num2cell(rangeLimMean(p,[j*2-1 j*2]))];
end
rangeLimMeanMat = [sort([uniqueMats; uniqueMats])';num2cell(rangeLimMean)];
headers = cell(2,length(fileNames)+1);
headers{1,1} = 'Range';
headers{2,1} = 'Mat';
for currentFile = 1:length(fileNames)
    headers{1,1+currentFile} = regexprep(shortNames{currentFile},'\.rrng','', 'ignorecase');
    headers{2,1+currentFile} = mat(currentFile);
end
% Save XLS file
%disp('Writing rangeSummary.xls file');
%xlswrite('rangeSummary.xls',headers,1,'A1');
%xlswrite('rangeSummary.xls',summary,1,'A2');

% using cellhist find ion occurance frequency
summary2 = summary(:,1);
summaryNum = summary(:,1); % numeric ion-range fraction (sort auto-replacements)
for r=1:size(summary,1)
    [n,ions]=cellhist(summary(r,logical([0 ~cell2mat(cellfun(@isempty,summary(r,2:end),'uni',0))]))');
    [~,in]=sort(n,'descend');
    %summary2(r,2:(length(n)*2+1)) = [ions(in)' cellfun(@(x)sprintf('%2.0f%%',x),num2cell(100*n(in)'./sum(n)),'uni',0)];
    summary2(r,2:(length(n)*2+1)) = [ions(in)' cellfun(@(x)sprintf('%3.0f',x),num2cell(n(in)'),'uni',0)];
    summaryNum(r,2:(length(n)*2+1)) = [ions(in)' num2cell(100*n(in)'./sum(n))];
end
% crop out all single entries (cut down on cluter)
summary2 = summary2(~cell2mat(cellfun(@isempty,summary2(:,4),'uni',0)),:);

% turn modeIons into ranges
modeRanges = cell(size(modeIons));
%TODO need to checkfor overlaps - probably should pick the smallest m/z
for i=1:length(modeIons)
    % make ion table
    [ionTable,elements]=ions2ionTable(ionStr2ions(modeIons{i}(:,1)));
    % sort element list
    [elements,ia] = elementSort(elements,{'Fe' 'Cr' 'Y' 'Ti' 'W' 'O' 'C' 'N'});
    modeIons{i}(:,3) = cellfun(@str2double,modeIons{i}(:,3),'uni',0);
    newRange = [modeIons{i}(:,[4 5 3 2]) num2cell(ionTable(:,ia))];
    newRange = sortrows(newRange,1);
    keepRanges =ones(size(newRange,1),1);
    for r=1:(size(newRange,1))
        % check for overlaps
        o = (cell2mat(newRange(:,1))<cell2mat(newRange(r,2))) & (cell2mat(newRange(:,1))>cell2mat(newRange(r,1)));
        keepRanges = keepRanges & ~o;
    end
    % remove duplicate ranges
    newRange = newRange(keepRanges,:);
    [newFile] = rangeWriter(newRange, elements, strcat('average_',uniqueMats{i}));
end
