% range vetting
% this collects all the range files from a dir and tabulates the ions and
% the rounded centres of their range:
% Centre    rrng1   rrng2 ...
% 6.0       C       C
% 12.0      -       C2
% Writes to 'rangeSummary.xls'
% A London April 2013

% plan:
% get range files
% read range files
% loop through ranges making a list:
%a) rounded to 0.1 and centred m/z value
%b) Ion ranged
%c) Name
% Put the above into the summary table above
% Write out to xls file.

maxRangeMz = 110; % maximum mass:charge ratio
binWidth = 0.1; %what the ranges are rounded to
start = 5; % minimum mass:charge ratio

addy = 'C:\Users\andy\APT\'; % get file location C:\ etc..
%addy ='C:\Users\andy\Documents\MATLAB\';
filelist =  dir([fileparts(addy) filesep '*.rrng']); % get all rrng files
fileNames = {filelist.name}';
summary = cell(round((maxRangeMz-start)/binWidth)+1,length(fileNames)+1);
summary(:,1) = num2cell(start:binWidth:maxRangeMz);

for currentFile = 1:length(fileNames)
    % read range file
    [element_num, range_num, elements, ranges] = rangeReader (fileNames{currentFile});
    % loop through ranges
    for r = 1:range_num
        % rounded centred range
        rc = round(((ranges{r,1}+ranges{r,2})/2)*(1/binWidth))*binWidth;
        % find row number to add ion to
        if(rc >= start)
            if(rc <= maxRangeMz)
                row = round((rc-start)/binWidth);
                % assign ion
                ion = makeIon(cell2mat(ranges(r,5:end)),elements);
                summary{row,currentFile+1} = ion{1};
            else
                disp(strcat('Range:',num2str(rc),' too large, increase max m/z'));
            end
        else
            disp(strcat('Range:',num2str(rc),' too small, decrease min m/z'));
        end
    end
end
% remove empty rows
for i = length(summary(:,1)):-1:1
    if(i<=length(summary(:,1)))
        % get the ion row, strcat the ions together, sum char values
        if ~sum(char(strcat(summary{i,2:end})))
            %disp(strcat('Removing row:',num2str(i)));
            summary(i,:) = [];
            %i = i - 2;
        end
    end
end
headers = cell(1,length(fileNames)+1);
headers{1,1} = 'Range';
for currentFile = 1:length(fileNames)
    headers{1,1+currentFile} = regexprep(fileNames{currentFile},'.rrng','', 'ignorecase');
end
disp('Writing rangeSummary.xls file');
xlswrite('rangeSummary.xls',headers,1,'A1');
xlswrite('rangeSummary.xls',summary,1,'A2');
% store in summary, reshape into 2 column (range,ion), sort = ordered range
% centres, how to restore the original names?
% need a global list of range centres
% how about every possible centre value, then cull ranges with no ion?
% sum(char(someCellArray{row,:})) % non-zero when containing an ion