%rangeUpdate script
% start diary
startDiary('rangeUpdate - matrix part');
selectedData = 99;
load('matrixRangeData.mat');
disp('Update 11022015 removed the portected ranges from the matrix range generator')
FWXM = 0.8; % FWf(X)M level from 0 to 1
protectedRanges = [26.97];%[15.99;29.635;31.974;52.45;63.949];
%% get range files
[d,cols]=dataBase('run>0',1); % load usable data sets
rcol = strcmp('rrng',cols);
aptRoot = 'C:\users\andy\APT\';
rangeRoot = 'C:\users\andy\APT\ranges\matrix\';
if(1)
emptyRanges = cell2mat(cellfun(@isempty,d(:,rcol),'uni',0));
if sum(emptyRanges)
    emptyRanges = find(emptyRanges);
    for i = 1:length(emptyRanges)
        cpy(regexprep(d{emptyRanges(i),strcmp('clrIdxRrng',cols)},'\.indexed',''),[aptRoot d{emptyRanges(i),strcmp('run',cols)} '.rrng']);
        d(emptyRanges(i),rcol) = [d(emptyRanges(i),strcmp('run',cols)) '.rrng'];
    end
end
%% add in extra ranges and find overlaps using rangeSynthetic
% load previous list of possible ions (generated by rangeVet2)
possibleIons = load('iList.mat');
possibleIons = possibleIons.iList;
% overlap = cell(size(d,1),1);
% ionRanges = cell(size(d,1),1);
oldDir = cd(rangeRoot);
for i=selectedData
    %if ~exist(regexprep(d{i,rcol},'\.rrng','s.rrng','ignorecase'),'file')
    cpy(strcat(aptRoot, d{i,rcol}),strcat(rangeRoot, d{i,rcol}));
    [newRanges,overlap{i},ionRanges{i}]=rangeSynthetic(d{i,rcol},possibleIons);
    delete(d{i,rcol}); % remove old range file
    %end
end
%% check ranges using Dan's rangeCheck.exe function
% now copy all ranges to apt\ranges\
for i=selectedData
    unix(['rangeCheck ' regexprep(d{i,rcol},'\.rrng','s.rrng','ignorecase')],'-echo');
end

%cd(oldDir);
%% use rangeCheck to remove ranges with no counts and
%% optimise using rangeCorrector
%checkedRanges = cell(size(d,1),3);
for i=selectedData
    posFile = strcat(d{i,strcmp('reconRoot',cols)},d{i,strcmp('pos',cols)});
    if exist(regexprep(posFile,'\.pos','.matrix.pos'),'file')
        posFile = regexprep(posFile,'\.pos','.matrix.pos');
    end
    rFile = strcat(rangeRoot,regexprep(d{i,rcol},'\.rrng','s.rrng','ignorecase'));
    checkedRanges{i,3} = rFile;
    checkedRanges{i,2} = posFile;
    [checkedRanges{i,1},newPossibleIons]=rangeCheck(rFile,posFile, protectedRanges, d{i,strcmp('startSkip',cols)},ionRanges{i},possibleIons);
    % if ions were removed from possibleIons then re-run range-synth/check
    if sum(size(newPossibleIons)~=size(possibleIons))
        [newRanges,overlap{i},ionRanges{i}]=rangeSynthetic(rFile,newPossibleIons);
        [checkedRanges{i,1},newPossibleIons2]=rangeCheck(regexprep(rFile,'\.rrng','s.rrng','ignorecase'),posFile, protectedRanges, d{i,strcmp('startSkip',cols)},ionRanges{i},newPossibleIons);
        if size(newPossibleIons)~=size(newPossibleIons2)
            error('Check the removed ions from this range');
        end
    else
        % rename [range]s -> [range]ss
        cpy(rFile,regexprep(rFile,'\.rrng','s.rrng','ignorecase'));
        checkedRanges{i,1}{1} = regexprep(rFile,'\.rrng','s.rrng','ignorecase');
        checkedRanges{i,3} = regexprep(rFile,'\.rrng','s.rrng','ignorecase');
    end
end
end
for i=selectedData
    [result] = rangeCorrector(checkedRanges{i,1},checkedRanges{i,2},FWXM);
    % save image of new ranges
    [~]=rangeDraw(result,gca,[rangeRoot num2str(d{i,1})]);
    close all
end
diary off
save('matrixRangeData.mat');