function [newRanges,overlapIons,ionRanges]=rangeSynthetic(rangeFile,possibleIons,suffix)
%[newRanges,overlapIons,peaks,rangeToPossibleIon]=rangeSynthetic(rangeFile,possibleIons,{output rrng file suffix})
% What elements are the in the range file? Add in all the ions with that
% element from the list of all possible ions.
% possibleIons = ionName colour volume charge state
% Eg: {'YO','0000FF','0.06184',[1 2]}
% You can also pass {fileName, element_num, range_num, elements, ranges} as returned
% by rangeReader if you want to modify the range file first (see
% rangeCheck for example).
% This function returns:
% -The new range table newRanges
% -A cell array of overlapping ions using the ALondon ions definition
% - ionRangeCentres the range centres and the ion index from possibleIons

% Read rrng file
if ischar(rangeFile)
    [element_num, range_num, elements, ranges] = rangeReader (rangeFile);
elseif length(rangeFile) == 5
    element_num = rangeFile{2};
    range_num   = rangeFile{3};
    elements    = rangeFile{4};
    ranges      = rangeFile{5};
    rangeFile   = rangeFile{1}; % set rangeFile = fileName
else
    [element_num, range_num, elements, ranges] = rangeReader (rangeFile);
end

[orgEle,ie] = sort(elements); % original range elements
[newIonTab,newEle] = ions2ionTable(ionStr2ions(possibleIons(:,1)));
% sort the new elements so ions are in the right order:
[newEle, ie] = elementSort(newEle,{'Fe','Cr','Y','Ti','W','Si','O','C','N','H'});
newIonTab = newIonTab(:,ie);

%ionsToAdd = cell(length(orgEle),1);
%chargeState = cell(length(orgEle),1);
%subordinateIons = {'O','C','N','H'}; % if present in orgEle then add their 
% self ions (O, O2 etc), but not other ions they are part of, eg WO,OH etc
% for i = 1:length(orgEle)
%     if sum(strcmp(orgEle{i},newEle))
%         % subordinate ion?
%         if sum(strcmp(orgEle{i},subordinateIons))
%             ionsToAdd{i}   = newIonTab(newIonTab(:,strcmp(orgEle{i},newEle))>0 & sum(newIonTab(:,~strcmp(orgEle{i},newEle)),2) ==0,:);
%             chargeState{i} = possibleIons(newIonTab(:,strcmp(orgEle{i},newEle))>0 & sum(newIonTab(:,~strcmp(orgEle{i},newEle)),2) ==0,4);
%         else % "major" ion therefore add all dependants
%             ionsToAdd{i}   = newIonTab(newIonTab(:,strcmp(orgEle{i},newEle))>0,:);
%             chargeState{i} = possibleIons(newIonTab(:,strcmp(orgEle{i},newEle))>0,4);
%         end
%     end
% end
[eleLogic,~]=ismember(newEle,orgEle); % find original elements in new elements
keeprows = sum(newIonTab(:,eleLogic),2)>0; % which rows have elements in still
% removerows=sum(newIonTab(keeprows,~a),2); % which rows have un-ranged elements in them
% a(a==0)=addions; % flag columns (elements) which were missing = 1
% ionsToAdd=newIonTab(keeprows,a);
keeprows(keeprows==1)=~(sum(newIonTab(keeprows,~eleLogic),2)>0);
ionsToAdd = newIonTab(keeprows,eleLogic);
chargeState = possibleIons(keeprows,4);
% remove empty cells
% ionsToAdd = ionsToAdd(~cell2mat(cellfun(@isempty,ionsToAdd,'uni',0)));
% chargeState= chargeState(~cell2mat(cellfun(@isempty,chargeState,'uni',0)));

% remove duplicates
% ionsToAdd = vertcat(ionsToAdd{:});
% chargeState = vertcat(chargeState{:});
% [ionsToAdd,ia]=unique(ionsToAdd,'rows');
% chargeState = chargeState(ia);
% remove zeros
for i=1:length(chargeState)
   chargeState{i} = chargeState{i}(chargeState{i}>0);
end
% makes ions
newIons = ionTable2ions(ionsToAdd,newEle(eleLogic),chargeState);
splitIons = cell(length(newIons),1);
% split ions with multiple charge states
for i = 1:length(newIons)
    c = newIons{i}{1}{1}; % charges
    t = cell(length(c),1); % temp cell
   for j=1:length(c)
       t{j}  = {newIons{i}{1}{1}(j),newIons{i}{2:end}};
   end
   splitIons{i} = t;
end
% each ion now has a separate charge state
splitIons = vertcat(splitIons{:});
% generate isotopic abundance and overlapped range centres (column 1)
peaks = peakHeights(splitIons);
% find overlapping ranges
overlapRanges = find(sum(peaks(:,2:end)>0,2)>1);
% return which ions (col) and ranges (row) are overlaped
[row,col]=find(peaks(overlapRanges(:),2:end)>0);
% make a list we can look at and use with the "overlap ID" as column 3
%overlaps = [overlapRanges(row) col (1:length(overlapRanges(row)))'];
overlaps = [overlapRanges(row) col col];
% group overlap IDs together using overlapping ions and ranges, 1st pass
% sortrows
% overlaps2=sortrows(overlaps,1);
% for i = 1:size(overlaps,1)
%     ionNums = overlaps2(overlaps2(:,1)==overlaps2(i,1),3);
% end
for i = 1:size(overlaps,1)
   ionNums = overlaps(overlaps(:,1)==overlaps(i,1),2); % which ions
   [Lia]=ismember(overlaps(:,2),ionNums);
   % which overlap IDs?
   oIDs = unique(overlaps(Lia,3));
   [Lib]=ismember(overlaps(:,3),oIDs);
   overlaps(Lia|Lib,3)=min(overlaps(Lia|Lib,3));
   %overlaps(overlaps(:,1)==overlaps(i,1) | overlaps(:,2)==overlaps(i,2),3) = min(overlaps(overlaps(:,1)==overlaps(i,1) | overlaps(:,2)==overlaps(i,2),2));
end
% run backwards for 2nd pass
% for i = size(overlaps,1):-1:1
%    overlaps(overlaps(:,1)==overlaps(i,1) | overlaps(:,2)==overlaps(i,2),3) = min(overlaps(overlaps(:,1)==overlaps(i,1) | overlaps(:,2)==overlaps(i,2),2));
% end

% make a cell array with each overlap ID as one cell
overlapIons = cell(max(overlaps(:,3)),1);
for i=1:max(overlaps(:,3))
    overlapIons{i} = splitIons(unique(overlaps(overlaps(:,3)==i,2)))';
end
% remove empties
overlapIons = overlapIons(~cell2mat(cellfun(@isempty,overlapIons,'uni',0)));
% check for rank deficiency
for o=1:length(overlapIons)
   overlapPeaks = peakHeights(overlapIons{o});
   if rank(overlapPeaks(:,2:end))~=size(overlapPeaks(:,2:end),2)
      % this set of overlaps is rank deficient and cannot be solved (there
      % is no unique solution to resolving this overlap)
      disp(ions2ionStr(overlapIons{o}));
      disp(['Range: ' num2str(min(overlapPeaks(:,1))) ' to ' num2str(max(overlapPeaks(:,1)))]);
      error('This set of overlaps is rank deficient and cannot be solved!');
   end
end
% pick ions for each range
% how? = highest peak abundance * approx composition
[comp,ele]=rangeComposition(rangeFile);
% ^This can be subbed for real composition if you have it
[roughCompIonTab,splitIonEle]=ions2ionTable(splitIons);
r = zeros(1,length(splitIonEle)); % composition of each element in roughCompIonTab
for e=1:length(splitIonEle)
    elePosit = strcmp(splitIonEle{e},ele);
    if sum(elePosit)
        r(e) = comp(elePosit);
    else
        r(e) = 0;
    end
end
ionicComp = (roughCompIonTab*(r'))'; % ionic composition or frequency
ionRange = zeros(size(peaks,1),1); % which ion index for each new range
% greatest abundance
for r=1:size(peaks,1)
    score = peaks(r,2:end).*ionicComp;
    [~,ionRange(r)]=max(score);
end
% set range widths
rs = 0.015; % before range size in sqrt(Da)
rf = 0.030; % after range size in sqrt(Da)

% make new ranges
[newIonTable,newElements]=ions2ionTable(splitIons(ionRange),newEle(eleLogic));

newRanges = cell(size(peaks,1),4+length(newElements));
% range starts and finishes (no check for overlaps)
newRanges(:,1) = num2cell(peaks(:,1)-rs.*sqrt(peaks(:,1)));
newRanges(:,2) = num2cell(peaks(:,1)+rf.*sqrt(peaks(:,1)));

newRanges(:,5:(length(newElements)+4)) =  num2cell(newIonTable); % ion table
% find the relation between the possibleIons and each range entry
% rangeToPossibleIon = zeros(size(newIonTable(:,1)));
% for i=1:size(newIonTable,1)
[~,rangeToPossibleIon] = ismember(newIonTable,newIonTab(keeprows,eleLogic),'rows');
posIonIndex = find(keeprows);
rangeToPossibleIon = posIonIndex(rangeToPossibleIon);
% end

% assign the colours and volumes from possibleIons list
newRanges(:,4) = possibleIons(rangeToPossibleIon,2); % colour from iList
newRanges(:,3) = cellfun(@str2num,possibleIons(rangeToPossibleIon,3),'uni',0); % vol from iList

% remove spare element columns from newRanges
p = sum(cell2mat(newRanges(:,5:end)),1)>0;
newRanges = newRanges(:,logical([1 1 1 1 p]));
newElements = newElements(p);
% sort elements
[newElements, ia] = elementSort(newElements,{'Fe','Cr','Y','Ti','W','Si','O','C','N','H'});
newRanges(:,5:end) = newRanges(:,4 + ia);
% write new range file?
if exist('suffix','var')==1
    suf = suffix;
else
    suf = 's';
end
rangeWriter(newRanges,newElements,regexprep(rangeFile,'\.rrng',suf,'ignorecase'));
ionRanges = [peaks(:,1) rangeToPossibleIon];

% check for duplicate ions in overlaps
assert(length(ions2ionStrChrg( horzcat(overlapIons{:})))==length(unique(ions2ionStrChrg( horzcat(overlapIons{:})))),'Duplicate ions in different overlaps detected')
% check for single ions in each overlap definition:
singleIons = find(cell2mat(cellfun(@(x) length(ions2ionStrChrg(x)),overlapIons,'uni',0))==1,1);
assert(~logical(sum(singleIons)),'An ion has been missed form being included in another overlap group: Mis-assigned overlap ion');