function [string] = rangeStr(fromRrngFile)
%fromRrngFile = 'Vol:0.06966 Cr:1 O:2 Color:FFAFAF'
%string = 0.06966,{1,'Cr','O',2},'FFAFAF';...
string =[];
[vol]=regexp(fromRrngFile,'(?<=Vol\:)\S+','match'); % volume
[col]=regexp(fromRrngFile,'(?<=Color\:)\S+','match'); % colour
[enum]=regexp(fromRrngFile,'(?<=[A-Z][a-z]?\:)\d+','match'); % element numbers
[els]=regexp(fromRrngFile,'[A-Z][a-z]?(?=\:\d+)','match'); % elements
string = [string vol{1} ',{1,'];
% charge state is set to one
for i=1:(length(enum)-1)
    string = [string '''' els{i} ''',' enum{i} ','];
end
string =     [string '''' els{end} ''',' enum{end} '},'];
string = [string '''' col{1} ''''];
end