function [h, heights, centres]=rangePlotter(rangeFile,posFile,num_bins)
%[h, heights, centres]=rangePlotter(rangeFile,posFile,num_bins)
% plots a range (currently only rrng) file on top of a mass spectrum
% returns the graph handle
logScale = 0; % flag for using logy scale, 0=linear, 1=logy
labelOffset = 100; % for text labels
labelScale = 2;
% read rrng file
[element_num, range_num, elements, ranges] = rangeReader (rangeFile);
extraCols = 4;
% pos file mass cache
masses = loadMasses(posFile);

% assign a number of bins
if(~exist('num_bins','var'))
    num_bins = 100000;
    disp(strcat(num2str(num_bins),'_bins'));
elseif (num_bins==0)
    num_bins = 100000;
    disp(strcat(num2str(num_bins),'_bins'));
end

disp('Plot histogram');
% hack for clsuter pos files that have little data
masses(end) = 200;
masses(end-1) = 0;
% / hack

[heights centres] = hist(masses,num_bins); % this plots a histogram
max(10,heights); % hack also
h = bar(centres,heights,'BarWidth',1); % this plots the bar chart
hold on;
if logScale
    set(gca,'yscale','log'); % **use log scale**
end
% set bin width
binwidth = centres(2)-centres(1);

% To colour the ranges:
% The patches have face-vertex syntax. First, get a handle for the
% children, and then obtain the vertices for the bars and
% the vertex color data:
ch = get(h,'Children');
%fvd = get(ch,'Faces'); % probably don't need this line
fvcd = get(ch,'FaceVertexCData');
fvcd2=ones(length(fvcd),3)*0.71; % make the whole thing light grey
% create array for range bounds
lines = ones(range_num*6,2)*.1; % fill in all values 0.1
% cycle through each range
for r = 1:range_num
    colour = ranges{r,4}; % set colour string (from file)
    col(1) = hex2dec(strcat(colour(1),colour(2)))/255; % red
    col(2) = hex2dec(strcat(colour(3),colour(4)))/255; % green
    col(3) = hex2dec(strcat(colour(5),colour(6)))/255; % blue
    % now assign the colour to each bar in that range
    % need to use centres and ranges(r,1) and ranges(r,2) to define the
    % width of the range
    % now find the bars in this range:
    % round((ranges{r,1}-centres(1))/binwidth) and with ranges{r,2}
    % now loop through them and assign the colour
    for i = (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth)
        for c=1:3
            for vert=1:5
                fvcd2(vert+5*(i-1),c) = col(c); % assign each colour r,g,b
            end
        end
    end
    
    % create lines
    lines((r-1)*6+1,1) = ranges{r,1}-binwidth/5;
    lines((r-1)*6+2,1) = ranges{r,1};
    lines((r-1)*6+3,1) = ranges{r,1}+binwidth/5;
    lines((r-1)*6+4,1) = ranges{r,2}-binwidth/5;
    lines((r-1)*6+5,1) = ranges{r,2};
    lines((r-1)*6+6,1) = ranges{r,2}+binwidth/5;
    if(1+round(ranges{r,1}/binwidth)<numel(heights))
        lines((r-1)*6+2,2) = heights(1+round(ranges{r,1}/binwidth));
        lines((r-1)*6+5,2) = heights(round(ranges{r,2}/binwidth));
    else
        lines((r-1)*6+2,2) = 10;
        lines((r-1)*6+5,2) = 10;
    end
end
set(ch,'FaceVertexCData',fvcd2); % set the new colour data on the plot
% sort lines
sortedlines = sortrows(lines);
%hold on;
% plot black lines where the edges of the current ranges are
%plot(sortedlines(:,1),sortedlines(:,2));

% read isotopes file - required file
if(exist('isotopes.mat','file'))
    isotopes = open('isotopes.mat');
    isotopes = isotopes.isotopes;
else
    disp('isotopes.mat file not found!');
end

% add ion labels
for r = 1:range_num
    % get ion name
    textIon = '';
    mass = 0;
    for e=1:element_num
        if(ranges{r,extraCols+e}>0)
            textIon = strcat(textIon,elements{e});
            index = find(not(cellfun('isempty', strfind(isotopes(:,1),strcat(elements{e},'(')))));
            mass = mass + isotopes{index(1),2}*ranges{r,extraCols+e};
            if(ranges{r,extraCols+e}>1)
                textIon = strcat(textIon,'_',num2str(ranges{r,extraCols+e}));
            end
        end
    end
    rangeCentre = (ranges{r,1}+ranges{r,2})/2;
    charge = round(mass/rangeCentre);
    for i=1:charge
        textIon = strcat(textIon,'^+');
    end
    text(rangeCentre,max(heights((1+round((rangeCentre-.05)/binwidth):(1+round((rangeCentre+.05)/binwidth)))))*labelScale+labelOffset,textIon,'Rotation',90,'HorizontalAlignment','center');
end
xlabel('mass/charge');ylabel('Counts');%xlim([0 150]);
hold off;
end