function [ionMasses]=rangeMass(ionTable,elements)
%[ionMasses]=rangeMass(ranges,elements)
% take a ion table and list of elements and return the list of ionic masses
% for that list
% A London Dec 2014

% read isotopes file - required file
if(exist('isotopes.mat','file'))
    isotopes = open('isotopes.mat');
    isotopes = isotopes.isotopes;
else
    disp('isotopes.mat file not found!');
end
elementM = zeros(length(elements),1);
for e=1:length(elements)
    % mass and abundance
    mAb = cell2mat(isotopes(~cell2mat((cellfun(@isempty,strfind(isotopes(:,1),[elements{e} '(']),'uni',0))),2:3));
    elementM(e) = mAb(:,1)'*mAb(:,2)/100;
end
ionMasses = ionTable*elementM;