function [ionNum,ionNames,rangeIonNum] = rangeM(listOfMasses,rangeTable,elements)
%[ionNum] = rangeM(listOfMasses,rangeTable,elements)
% Takes a list of masses and a range table formatted:
% rangeStart rangeEnd element1 element2 ... elementN
% and returns a list the same size of listOfMasses with 0 being unranged
% and a number corresponding to the ion names in the ionNames list defined
% by the elements in "elements" (cell array with as many columns 
% as rangeTable -2)
% To get the rangeTable from a rrng file:
% [element_num, range_num, elements, ranges] = rangeReader('file.rrng');
% rangeTable = cell2mat(ranges(:,[1 2 5:end]));
ionRanges = makeIon(rangeTable(:,3:end),elements)';
[ionNames,ia,rangeIonNum] = unique(ionRanges,'stable');
ionNum = zeros(size(listOfMasses));
for r=1:length(rangeTable(:,1))
    ionNum((listOfMasses >= rangeTable(r,1)) & (listOfMasses <= rangeTable(r,2))) = rangeIonNum(r);
end
end