% Range Correcting script to locate specific errors and delete ranges

% error definition
corrections = {26,1,0.01201,{1,'Cr',1},'FF33CC',{1,'Fe'};...
            32.00,1,0.057660,{1,'O',2},'FF3333',{1,'O',1};...
            32.97,1,0.04083,{1,'Cr',1,'O',1},'FFFF00',{1,'Cr','O',2};...
            33.96,1,0.04083,{1,'Cr',1,'O',1},'FFFF00',{1,'Cr','O',2};...
            34.47,1,0.04083,{1,'Cr',1,'O',1},'FFFF00',{1,'Cr','O',2};...
            34.97,1,0.03400,{1,'Fe','N'},'FF0000',{1,'Cr','N'};...
            36.98,0,0.1,{1,'Fe','O'},'FF0000',{1,'Fe','O'};...
            45.99,0,0.01573,{1,'W',1},'330033',{1,'W',1};...
            52.95,0,0.09067,{1,'Y',1,'O',1},'00FF00',{1,'Y','O'};...
            54.98,0,0.01177,{1,'Fe',1},'FF00FF',{1,'Fe',1};...
            60.45,1,0.09067,{1,'Y',1,'O',2},'00FFFF',{1,'Y','O'};...
            67.95,1,0.04083,{1,'Cr',1,'O',1},'FFFF00',{1,'Cr','O',2};...
            68.94,1,0.04083,{1,'Cr',1,'O',1},'FFFF00',{1,'Cr','O',2};...
            85.00,1,0.06966,{1,'Cr','O',2},'FFAFAF',{1,'Cr',1,'O',1}};
% range centre, keep, ion volume, ion, new colour, ion to replace

% get range files
froot = 'C:\Users\andy\APT\ranges\';
names = dir(strcat(froot,'*.rrng'));
names ={names.name}';
names = strcat(froot,names);
saveOrNot = 1; % saving flag, 1 to re-right files
% loop over files
for f=1:size(names,1)
    changedFlag = 0; % sert if a change occurs
    % load range file
    [element_num, range_num, elements, ranges] = rangeReader(names{f});
    a=cell2mat(ranges(:,1:2)); % matrix of range bounds
    % loop over corrections
    for i=1:size(corrections,1)
        % identifiy errors
        r = find(a(:,1)<corrections{i,1} & a(:,2)>corrections{i,1});
        if r % if matching range is found
            % check for the offending ion
            try
                errRow = ions2ionTable(corrections(i,6),elements);
            catch missingErrorElement
                % probably ok to ignore
                errRow = zeros(size(ranges(r,5:end)));
            end
            if ~sum(errRow~=cell2mat(ranges(r,5:end)))
                % they are identical, so replace it
                if ~corrections{i,2}
                        disp(names{f});
                    disp(strcat('deleting range:',sprintf('%6.2f',ranges{r,1}),':',makeIon(errRow,elements)));
                    ranges(r,:) = []; % delete range
                    a(r,:) = []; % delete from 'a' as well
                    changedFlag = 1;
                else
                    try
                        ionRow = ions2ionTable(corrections(i,4),elements);
                    catch missingNewElement
                        disp(names{f});
                        ionRow = ions2ionTable(corrections(i,4),elements);
                    end
                    % replace row and colour and volume
                        disp(names{f});
                    disp(strcat('replacing range:',sprintf('%6.2f',ranges{r,1}),':',makeIon(cell2mat(ranges(r,5:end)),elements)));
                    disp(strcat('with:',sprintf('%6.2f',ranges{r,1}),':',makeIon(ionRow,elements)));
                    ranges(r,5:end) = num2cell(ionRow);
                    ranges{r,3} = corrections{i,3}; % volume
                    ranges{r,4} = corrections{i,5}; % colour
                    changedFlag = 1;
                end
            end
        end
    end
    if saveOrNot && changedFlag
        % write out new range file
        rangeWriter(ranges,elements,regexprep(names{f},'.rrng','','ignorecase'));
    end
end