function tempImages=rangeDraw(ranges,h,imageOutFile)
%rangeDraw
% Draw each of the ranges separately after running rangeCorrector, saves
% images as PNG and saves image files as imageOutFile.png
tempImages = cell(size(ranges,1),1);
%axesObjs = get(gca, 'Children');  %axes handles
%dataObjs = get(axesObjs, 'Children'); %handles to low-level graphics objects in
%objTypes = get(dataObjs, 'Type');  %type of low-level graphics object
heights = get(get(h, 'Children'), 'YData');
heights = heights{end};
centres = get(get(h, 'Children'), 'XData');
centres = centres{end};
% plot outline
hold on
plot(centres,heights,'b-');
hold off
for r=1:size(ranges,1)
    % plot window
    xlim([ranges{r,5}-0.1 ranges{r,7}+0.1]); % zoom to section
    %ylim([1 max(heights(centres > ranges{r,5} & centres < ranges{r,7}))*1.5]);
    % save temp image
    tempImages{r} = hardcopy(h, '-Dzbuffer', '-r0');
%     print(gcf,'-dmeta');
%     tempImages{r} = imclipboard('paste');
end

% stitch images
ih = size(tempImages{1},1); % image height
iw = size(tempImages{1},2); % image width
newImage = zeros(ih,iw*length(tempImages),3);
for i = 1:length(tempImages)
    newImage(1:ih,((i-1)*iw+1):i*iw,:) = tempImages{i}(1:ih,1:iw,:);
end
imwrite(newImage,[imageOutFile '.png'],'png');
end