function [ranges,centres,heights]=rangeCounterSimple(masses,ranges,h)
% takes a list of masses and a set of ranges and returns the noise
% corrected counts for those ranges, does not do a deconvolution into
% atomic counts. ranges should be matrix of two columns, range start value
% and range end value.
% h is the graphics handle to plot into
% the counts are returned as ranges(:,3)
binwidth = 0.005;
plotStart = 2; % offset for plotting in amu
ranges = num2cell(ranges);
minm = min(cell2mat(ranges(:,1)))-plotStart; % min and max masses
maxm = max(cell2mat(ranges(:,1)))+plotStart; % for histogram

% generate histogram
[heights, centres] = hist(masses,minm:binwidth:maxm);
if nargin<3 % plotting or not?
    plotting = 0;
else
    plotting = 1;
    plot(h,centres(2:end-1),heights(2:end-1),'b-');
    hold on;
end

for r = 1:length(ranges(:,1))
    %disp(ranges{r,1});
    % for counting
    %rangeWidth = round(1+(ranges{r,2})/binwidth)-(round((ranges{r,1})/binwidth));
    %thisHits = 0;
    %preNoiseHits = 0;
    %postNoiseHits = 0;
    % fit pre window noise using exp1
    % note the currently fixed window width
    preNoiseWindowStart = (ranges{r,2}-ranges{r,1})*1.2; %0.3; % relative to range start, ie 0.3 before
    if preNoiseWindowStart < 0.1
        preNoiseWindowStart = 0.1;
    end
    preNoiseWindowEnd = (ranges{r,2}-ranges{r,1})*0.2; %0.08; % relative to range start
    if preNoiseWindowEnd < 0.05
        preNoiseWindowEnd = 0.05;
    end
    % select the x y data to fit the noise curve to
    %disp((ranges{r,1}-preNoiseWindowStart)/binwidth);
    preNoiseX = centres( (1+round((ranges{r,1}-preNoiseWindowStart-minm)/binwidth)):round((ranges{r,1}-preNoiseWindowEnd-minm)/binwidth) )';
    preNoiseY = heights( (1+round((ranges{r,1}-preNoiseWindowStart-minm)/binwidth)):round((ranges{r,1}-preNoiseWindowEnd-minm)/binwidth) )';
    rangeX = centres( (1+round((ranges{r,1}-minm)/binwidth)):round((ranges{r,2}-minm)/binwidth) );
    %rangeY = heights( (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth) );
    
    % fit to an exp in sqrt space:
    [expNoiseFit,expPredictor,stderror] = noiseFit(preNoiseX,preNoiseY,rangeX);

    ftype = 'exp1';
    % calc noise counts
    %noiseCountsLower = sum(expPredictor(:,1));
    noiseCounts = expNoiseFit(rangeX.^2);
    if sum(noiseCounts) == 0
        % use a different noise estimate:
        %disp('Using linear noise est');
        if plotting
            plot([preNoiseX; rangeX'],expNoiseFit([preNoiseX; rangeX'].^2),'kx');
        end
        ft = fittype( 'poly1' );
        ftype = 'poly1';
        opts = fitoptions( ft );
        %opts.Display = 'Off';
        opts.Lower = [-binwidth*5 0];
        %opts.StartPoint = [0 1];
        opts.Upper = [0 Inf];
        [expNoiseFit, ~] = fit(preNoiseX,preNoiseY,ft,opts);
        %plot(preNoiseX,expNoiseFit(preNoiseX),'g-');
        noiseCounts = expNoiseFit(rangeX);
    end
    %noiseCountsUpper = sum(expPredictor(:,2));
    thisHits = heights( (1+round((ranges{r,1}-minm)/binwidth)):round((ranges{r,2}-minm)/binwidth) );
    %thisHits = heights( (1+round((ranges{r,1}-minm)/binwidth)):round((ranges{r,2}-minm)/binwidth) )'-noiseCounts;
    %thisHits = sum(thisHits(thisHits>0));
    if(0)
        for i = (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth)
            % while we're here, count the hits in this range:
            % and the hits for the pre & post noise windows
            %thisHits = thisHits + heights(i); % done using sum above
            
            if(noiseWinidow>0)
                % use a number of range windows
                preNoiseHits = preNoiseHits + heights(i-rangeWidth*noiseWinidow);
                postNoiseHits = postNoiseHits + heights(i+rangeWidth*noiseWinidow);
            elseif (noiseWindowAbs>0)
                % use an absolute distance
                preNoiseHits = preNoiseHits + heights(i-round(noiseWindowAbs/binwidth));
                postNoiseHits = postNoiseHits + heights(i+round(noiseWindowAbs/binwidth));
            else
                % use default
                preNoiseHits = preNoiseHits + heights(i-rangeWidth*3);
                postNoiseHits = postNoiseHits + heights(i+rangeWidth*3);
            end
        end
    end
    %ranges{r,5} = noiseCountsLower; % total hits in this range
    %disp([thisHits noiseCounts]);
    %ranges{r,3} = thisHits;%;-noiseCounts; % corrected counts
    ranges{r,3} = sum(thisHits)-sum(noiseCounts); 
    if ranges{r,3} < 0
        %disp(num2str(ranges{r,1}));
        %disp('Negative counts! Probably due to bad noise fitting');
        % try the alternative noise subtraction:
        thisHits = thisHits-noiseCounts';
        thisHits = sum(thisHits(thisHits>0));
        if thisHits > 0
            %disp('Used alternative noise subtraction');
            %disp(thisHits);
            ranges{r,3} = thisHits;
        else
            ranges{r,3} = 0;
        end
    end
    %ranges{r,7} = noiseCountsUpper;
    %ranges{r,8} = thisHits;
    %ranges{r,9} = stderror;
    % not used %postNoiseHits; % total hits in this range
    if plotting
        % plot the fit
        %testVar(:,1) = centres( (1+round((ranges{r,1}-preNoiseWindowStart-minm)/binwidth)):round((ranges{r,2}+preNoiseWindowStart-minm)/binwidth) )';
        %testVar(:,2) = heights( (1+round((ranges{r,1}-preNoiseWindowStart)/binwidth)):round((ranges{r,2}+preNoiseWindowStart)/binwidth) )';
        %testVar(:,3) = expNoiseFit.a*exp(expNoiseFit.b.*(testVar(:,1).^2));
        %plot(testVar(:,1),testVar(:,3),'r')
        if strcmp(ftype,'exp1')
            plot(rangeX,expNoiseFit(rangeX.^2),'r-');
        else
            plot(rangeX,expNoiseFit(rangeX),'r-');
        end
        %clear testVar
    end
end
if plotting
    hold off
end
end