function [composition, ranges, peak32counts] = rangeCounter(rangeFile,posFile)
% rangeCounter
% script to give the counts (from a histogram) with a particular rrng file
% and pos file. Returns: 'decomposed composition' and 'full range file with
% counts and noise per range'
% Has some hard coded work at line 145 to deconvolve the 32 TiO/O2 peak
% Original work by A London Nov 2012

noiseWinidow = 0; % the number of range-widths away the noise window is
noiseWindowAbs = 0.1; % the m/z distance the noise window is away
percentages = 0;
% bin the data
num_bins = 200000;

% open and read rrng file
fid = fopen(rangeFile);
tline = fgets(fid); % this is the first line from the rrng file, [Ions]
if(strcmp(cellstr(tline),'[Ions]'))
    % note the cellstr removes the white space
    %keep going
    disp('Reading ions...');
else
    disp('Error reading [Ions] tag from range file');
    return;
end
% get the 2nd line
tline = fgets(fid);
% this is the number of elements
element_num = sscanf(tline,'Number=%f');
disp(element_num); % debug - number of elements in ranges
%make the elements cell array
elements = cell(element_num,1);
% for the next element_num lines, read the ions into the elements list
for e = 1:element_num
    tline = fgets(fid);
    S =  textscan(tline,'Ion%*u8=%s');
    elements(e,1) = S{1};
    %disp(textscan(tline,'Ion%*u8=%s'));
end
% so Ion1 is elements{1} = 'Fe' for example
% the next line should be [Ranges]
tline = fgets(fid);
if(strcmp(cellstr(tline),'[Ranges]'))
    % note the cellstr removes the white space
    %keep going
    disp('Read elements');
else
    disp('Error reading elements from range file');
    return;
end
% get the next line
tline = fgets(fid);
% this is the number of ranges
range_num = sscanf(tline,'Number=%f');
extraCols = 9;
ranges = cell(range_num,element_num+extraCols); % make an array to store the range details
% 1          2        3   4      5      6     7      8     9     10
% rangeStart rangeEnd vol colour noiseL noise noiseU count error element1 ... elementN
% read the range file and store the results in 'ranges' var
for r = 1:range_num
    tline = fgets(fid);
    C = textscan(tline,'Range%*u8=%f %f');
    ranges{r,1} = C{1};
    ranges{r,2} = C{2};
    %disp(extscan(tline,'Ion%*u8=%s'));
    % TO DO: read the rest of the range data, not just the masses
    % find the elements present in ranged ion
    for e = 1:element_num
        % this adds the number of each element present to the 'ranges' table
        % it scans for each element, e, in the line from the range file
        % then it adds on the right number of characters to move to the
        % position of the number of that element present in the ranged ion
        % The strcat...':' is so that it finds 'Co:#' not 'Color ect'
        % disp(strfind(tline,strcat(elements{e},':')));
        numOfE = str2double(tline(strfind(tline,strcat(elements{e},':'))+length(elements{e})+1));
        if(~isnan(numOfE))
            ranges{r,extraCols+e} = numOfE;
        else
            ranges{r,extraCols+e} = 0;
        end
    end
    % find ion volume information
    vol = textscan(tline,'%*s %*f Vol:%f');
    ranges{r,3} = vol{1};
    % find colour information
    color = textscan(tline(strfind(tline,'Color:'):end),'Color:%s');
    ranges(r,4) = color{1};
end
fclose(fid);

% don't need this any more
if(0)
    % pos file mass cache
    posFileM = strcat(regexprep(posFile,'\.pos',''),'_m.mat');
    % check for cached masses
    if(exist(posFileM,'file'))
        % load masses from a file
        % using .m as it is compressed compared to .txt
        disp(strcat('Loading cached masses:',posFileM));
        load(posFileM,'masses');
    else
        % open pos file and store masses
        disp('Open pos file');
        masses = readpos_mass(posFile);
        % save the masses for next time
        disp(strcat('Saving cached masses:',posFileM));
        save(posFileM,'masses');
    end
    disp('Plot histogram');
    % hack for clsuter pos files that have little data
    masses(end) = 200;
    masses(end-1) = 0;
    % basic plotting
    %[heights centres] = hist(masses,num_bins); % this plots a histogram
    %h = bar(centres,heights,'BarWidth',1); % this plots the bar chart
end

% fancy plotting
[h,heights, centres] = rangePlotter(rangeFile,posFile,num_bins);

binwidth = centres(2)-centres(1);
disp('count ranges');

hold on;
for r = 1:range_num
    disp(ranges{r,1});
    % for counting
    rangeWidth = round(1+(ranges{r,2})/binwidth)-(round((ranges{r,1})/binwidth));
    %thisHits = 0;
    %preNoiseHits = 0;
    %postNoiseHits = 0;
    % fit pre window noise using exp1
    % note the currently fixed window width
    preNoiseWindowStart = (ranges{r,2}-ranges{r,1})*2; %0.3; % relative to range start, ie 0.3 before
    if preNoiseWindowStart < 0.1
        preNoiseWindowStart = 0.1;
    end
    preNoiseWindowEnd = (ranges{r,2}-ranges{r,1})*0.5; %0.08; % relative to range start
    if preNoiseWindowEnd < 0.05
        preNoiseWindowEnd = 0.05;
    end
    % select the x y data to fit the noise curve to
    preNoiseX = centres( (1+round((ranges{r,1}-preNoiseWindowStart)/binwidth)):round((ranges{r,1}-preNoiseWindowEnd)/binwidth) )';
    preNoiseY = heights( (1+round((ranges{r,1}-preNoiseWindowStart)/binwidth)):round((ranges{r,1}-preNoiseWindowEnd)/binwidth) )';
    rangeX = centres( (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth) );
    %rangeY = heights( (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth) );
    
    % fit to an exp in sqrt space:
    [expNoiseFit,expPredictor,stderror] = noiseFit(preNoiseX,preNoiseY,rangeX);
    
    % calc noise counts
    noiseCountsLower = sum(expPredictor(:,1));
    noiseCounts = sum(expNoiseFit(rangeX.^2));
    noiseCountsUpper = sum(expPredictor(:,2));
    thisHits = sum(heights( (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth) ));
    if(0)
        for i = (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth)
            % while we're here, count the hits in this range:
            % and the hits for the pre & post noise windows
            %thisHits = thisHits + heights(i); % done using sum above
            
            if(noiseWinidow>0)
                % use a number of range windows
                preNoiseHits = preNoiseHits + heights(i-rangeWidth*noiseWinidow);
                postNoiseHits = postNoiseHits + heights(i+rangeWidth*noiseWinidow);
            elseif (noiseWindowAbs>0)
                % use an absolute distance
                preNoiseHits = preNoiseHits + heights(i-round(noiseWindowAbs/binwidth));
                postNoiseHits = postNoiseHits + heights(i+round(noiseWindowAbs/binwidth));
            else
                % use default
                preNoiseHits = preNoiseHits + heights(i-rangeWidth*3);
                postNoiseHits = postNoiseHits + heights(i+rangeWidth*3);
            end
        end
    end
    ranges{r,5} = noiseCountsLower; % total hits in this range
    ranges{r,6} = noiseCounts; % total hits in this range
    ranges{r,7} = noiseCountsUpper;
    ranges{r,8} = thisHits;
    ranges{r,9} = stderror;
    % not used %postNoiseHits; % total hits in this range
    % plot the fit
    testVar(:,1) = centres( (1+round((ranges{r,1}-preNoiseWindowStart)/binwidth)):round((ranges{r,2}+preNoiseWindowStart)/binwidth) )';
    %testVar(:,2) = heights( (1+round((ranges{r,1}-preNoiseWindowStart)/binwidth)):round((ranges{r,2}+preNoiseWindowStart)/binwidth) )';
    testVar(:,3) = expNoiseFit.a*exp(expNoiseFit.b.*(testVar(:,1).^2));
    plot(testVar(:,1),testVar(:,3),'r')
    clear testVar
end
hold off;
% for decomposing the counts
if(1)
    rangeCounts = cell2mat(ranges(:,8));
    bgCorrectedCounts = cell2mat(ranges(:,8))-cell2mat(ranges(:,6));
    % remove negatives
    bgCorrectedCounts = max(0,bgCorrectedCounts);
    decompCounts = (transpose(cell2mat(ranges(:,extraCols+1:extraCols+element_num)))*rangeCounts);
    bgDecompCounts = (transpose(cell2mat(ranges(:,extraCols+1:extraCols+element_num)))*bgCorrectedCounts);
    composition = cell(element_num,3);
    composition(:,1) = elements;
    if(percentages)
        composition(:,2) = num2cell(100*decompCounts./sum(decompCounts));
        composition(:,3) = num2cell(100*bgDecompCounts./sum(bgDecompCounts));
    else
        composition(:,2) = num2cell(decompCounts);
        composition(:,3) = num2cell(bgDecompCounts);
    end
    %disp('Composition:');
    %disp(result);
end

% for deconvolving the 32 peak
if(0)
    ion1 = 'Ti';
    ion2 = 'O';
    ionRange = [30.5 33.3];
    % find the elements of the target ion
    for e=1:element_num
        if(strcmp(elements(e),ion1))
            % found ion1
            ion1e = e;
        elseif(strcmp(elements(e),ion2))
            % found ion1
            ion2e = e;
        end
    end
    % warning this is rather hard coded = not great
    % find the ranges that correspond to these ions
    ionMask = cell2mat(ranges(:,extraCols+ion1e)).*cell2mat(ranges(:,extraCols+ion2e));
    possibleCount = sum(min(1,ionMask));
    disp(strcat('possible range no.:',num2str(possibleCount)));
    possibleRanges = cell(possibleCount,element_num+extraCols);
    count = 1;
    isotopes = [.08, .073, .738, .055, .054];
    for r=1:range_num
        if(ionMask(r))
            possibleRanges(count,:) = ranges(r,:);
            count = count + 1;
        end
    end
    for r=1:(count-1)
        if(possibleRanges{r,2}<ionRange(2))
            if(possibleRanges{r,2}>ionRange(1))
                if(possibleRanges{r, 8}-possibleRanges{r, 6})>0
                    % background correction (remove pre counts)
                    possibleRanges{r, extraCols+1} = (possibleRanges{r, 8}-possibleRanges{r, 6})/isotopes(r);
                end
            end
        end
    end
    restoredCounts = mean(cell2mat(possibleRanges([1:2 4], extraCols+1)));%sum(cell2mat(possibleRanges([1:2 4], extraCols+1)))/3;
    O2Counts = cell2mat(possibleRanges(3, extraCols+1))-restoredCounts;
    TiOCounts = restoredCounts;
    peak32error = std(cell2mat(possibleRanges([1:2 4], extraCols+1)));
    O2per = O2Counts/possibleRanges{3, extraCols+1};
    TiOper = TiOCounts/possibleRanges{3, extraCols+1};
    disp(strcat('TiO:',num2str(TiOper*100,3),'% O2:',num2str(O2per*100,3),'% ',num2str((peak32error*100)/possibleRanges{3, extraCols+1},3)));
    peak32counts = transpose(possibleRanges(1:4, extraCols+1));
else
    peak32counts = 0;
end

%result = ranges;
end