%function result = rangeCorrectorArea(rangeFile,posFile,level,num_bins)
%function result = rangeCorrectorArea(rangeFile,posFile,level,{num_bins})
% Only reads rrng files and pos files with .pos extentsion
% Estimate the range width from a percentage of peak area (level) estimated
% from a cumulative distribution function of the m/z histogram
% A. London Aug 2014
if ~exist('num_bins','var')
    num_bins = 50000; % mass resolution = massSpecMax/num_bins
end
massSpecMax = 200; % maximum mass spectrum value for small pos files
noiseWinidow = 1; % the number of range-widths away the noise window is
attemptLim = 25; % number of attempts before giving up fitting BG

[element_num, range_num, elements, ranges] = rangeReader (rangeFile);
% Make ranges bigger to store the extra information
extraCols = 10;
newRanges = cell(range_num,element_num+extraCols); % make an array to store the range details
% 1          2        3   4      5    6    7    8        9         10...
% rangeStart rangeEnd vol colour newR newC newL preNoise postNoise Counts element1 ... elementN
% Copy original info
newRanges(:,1:4) = ranges(:,1:4);
% Copy ion info
newRanges(:,(extraCols+1):(extraCols+element_num)) = ranges(:,5:end);
% Assign new ranges var
ranges = newRanges;
% pos file mass cache
[masses] = loadMasses(posFile);
disp('Plot histogram');

% hack for clsuter pos files that have little data
masses(end) = massSpecMax;
masses(end-1) = 0;
% bin the data
[heights, centres] = hist(masses,num_bins); % this plots a histogram
h = bar(centres,heights,'BarWidth',1); % this plots the bar chart
hold on;
%set(gca,'yscale','log'); % **use log scale**
% measure bin width
binwidth = centres(2)-centres(1);
hs=centres(1:2); % first two bins of centres, used by the bx function
% To colour the ranges:
% The patches have face-vertex syntax. First, get a handle for the
% children, and then obtain the vertices for the bars and
% the vertex color data:
ch = get(h,'Children');
%fvd = get(ch,'Faces'); % probably don't need this line
fvcd = get(ch,'FaceVertexCData');
fvcd2=ones(length(fvcd),3)*0.71; % make the whole thing light grey
% create array for range bounds
lines = ones(range_num*6,2)*.1; % fill in all values 0.1
% cycle through each range
for r = 1:range_num
    colour = ranges{r,4}; % set colour string (from file)
    col(1) = hex2dec(strcat(colour(1),colour(2)))/255; % red
    col(2) = hex2dec(strcat(colour(3),colour(4)))/255; % green
    col(3) = hex2dec(strcat(colour(5),colour(6)))/255; % blue
    % for counting
    rangeWidth = round(1+(ranges{r,2})/binwidth)-(round((ranges{r,1})/binwidth));
    thisHits = 0;
    preNoiseHits = 0;
    postNoiseHits = 0;
    %disp(red);
    % now assign the colour to each bar in that range
    % need to use centres and ranges(r,1) and ranges(r,2) to define the
    % width of the range
    % now find the bars in this range:
    % round((ranges{r,1}-centres(1))/binwidth) and with ranges{r,2}
    % now loop through them and assign the colour
    for i = (1+round((ranges{r,1})/binwidth)):round((ranges{r,2})/binwidth)
        for c=1:3
            for vert=1:5
                fvcd2(vert+5*(i-1),c) = col(c); % assign each colour r,g,b
            end
        end
        % while we're here, count the hits in this range:
        % and the hits for the pre & post noise windows
        thisHits = thisHits + heights(i);
        preNoiseHits = preNoiseHits + heights(round(i-rangeWidth*noiseWinidow));
        postNoiseHits = postNoiseHits + heights(round(i+rangeWidth*noiseWinidow));
    end
    ranges{r,8} = thisHits; % total hits in this range
    ranges{r,9} = preNoiseHits; % total hits in this range
    ranges{r,10} = postNoiseHits; % total hits in this range
    % create lines
    lines((r-1)*6+1,1) = ranges{r,1}-binwidth/5;
    lines((r-1)*6+2,1) = ranges{r,1};
    lines((r-1)*6+3,1) = ranges{r,1}+binwidth/5;
    lines((r-1)*6+4,1) = ranges{r,2}-binwidth/5;
    lines((r-1)*6+5,1) = ranges{r,2};
    lines((r-1)*6+6,1) = ranges{r,2}+binwidth/5;
    lines((r-1)*6+2,2) = heights(1+round(ranges{r,1}/binwidth));
    lines((r-1)*6+5,2) = heights(round(ranges{r,2}/binwidth));
end
set(ch,'FaceVertexCData',fvcd2); % set the new colour data on the plot
% sort lines
sortedlines = sortrows(lines);
% plot black lines where the edges of the current ranges are
plot(sortedlines(:,1),sortedlines(:,2));
hold off;
% background estimation
% remove ranged data + extra
ranged = zeros(size(heights));
noisePad = 0.3; % distance to remove either side of ranges in Da
for r = 1:range_num
    % logical array if bins are ranged or not
    ranged((1+round((ranges{r,1}-centres(1)-noisePad)/binwidth)):round((ranges{r,2}-centres(1)+noisePad)/binwidth)) = 1;
end
% remove based on ranged or not
xnf=centres(~ranged);ynf=heights(~ranged);
xnf=xnf(ynf<heights(1)); ynf=ynf(ynf<heights(1));
fitn = fit(sqrt(xnf'),ynf','poly1','Robust', 'bisquare'); % noise fit

c=cumsum(heights); % cumalative sum
c = (c-min(c))./max(c-min(c));
ranges = sortrows(ranges,1);
fits = zeros(range_num,4); %p1, p2, q1, gof
maxes = zeros(range_num,1); % max of diff of pre-peak
resultfit = zeros(range_num,1); % fitness results
onsets = zeros(range_num,1); % peak onsets
%hold on
for r = 1:range_num
    %disp(r);
    % find range peak
    rw = ranges{r,2}-ranges{r,1};% range width in m/z space
    % range width in bins
    rangeWidth = round(1+(ranges{r,2})/binwidth)-(round((ranges{r,1})/binwidth));
    % look around the range in order to remove the background
    if ( round(1+ranges{r,2}/binwidth)-round(ranges{r,1}/binwidth) ) > 3
        [pks, locs] = findpeaks(heights((round(ranges{r,1}/binwidth)):round(1+ranges{r,2}/binwidth)),'minpeakdistance',rangeWidth-1,'minpeakheight',heights(round(ranges{r,1}/binwidth))-1);
    else
        % too few bins to find a peak, so expand the original range width
        error('Too few bins for good fitting!');
        [pks, locs] = findpeaks(heights((round(ranges{r,1}/binwidth)-1):round(2+ranges{r,2}/binwidth)),'minpeakdistance',rangeWidth-1,'minpeakheight',heights(round(ranges{r,1}/binwidth))-1);
    end
    if length(locs)~=1
        % use a dumb maximum instead, this behaviour is expected when the
        % range doesn't have a peak in it though!
        [pks,locs]=max(heights((round(ranges{r,1}/binwidth)):round(1+ranges{r,2}/binwidth)));
        %error(strcat('no peak found:',num2str(r),'; try reranging original file'));
    end
    xbin = locs+round(ranges{r,1}/binwidth)-1; % bin number of range centre
    ranges{r,6}=centres(xbin); % make a note of range centre for later
    
    % find peak onset
    % smoothed pre-range window
    prw = noiseWinidow*rw; % pre range window width (in Da)
    onsetY = smooth(heights(bx(ranges{r,1}-prw,hs):bx(ranges{r,1},hs)));
    [pkos,pkosI] = min( onsetY );
    pkosI = pkosI+bx(ranges{r,1}-prw,hs); % global bin number
    %plot(centres(pkosI),pkos,'rx');
    linCheck = -1;
    offset = 0;
    attempt = 0;
    while linCheck<0 && attempt<attemptLim
        % find the pre-range for background fitting
        % OLD code
        %         if r>1 % ie not first range
        %             xstart = max(ranges{r-1,2},ranges{r,1}-noiseWinidow*rw)-offset;
        %         else
        %             % just use noise window
        %             xstart = ranges{r,1}-noiseWinidow*rw-offset;
        %         end
        % /OLD
        if r<range_num % ie not last range
            xend = min(ranges{r+1,1},ranges{r,2}+noiseWinidow*rw*4);
        else
            % just use noise window
            xend = ranges{r,2}+noiseWinidow*rw*4;
        end
        xOnset=centres(pkosI); % onset of the peak
        % noise to fit before the peak
        if r>1 % ie not first range
            xstart = max(ranges{r-1,2},xOnset-noiseWinidow*rw)-offset;
        else
            % just use noise window
            xstart = xOnset-noiseWinidow*rw-offset;
        end
        % whole window
        x = centres(centres>=xstart & centres<=xend)-xstart;
        y = c(centres>=xstart & centres<=xend);
        % fit from xstart until half way through the -noise window-
        xnf=centres(centres>=xstart & centres<=xOnset)-xstart;
        ynf=c(centres>=xstart & centres<=xOnset);
        maxes(r) = max(diff(ynf));
        
        % try fitting linear first
        [fitp, gof] = fit(xnf',ynf','poly1');
        % check fitting
        xc = x(end-15:end);
        cfitted = y'-fitp(x); % cumalative, BG subtracted
        yc = cfitted(end-15:end);
        fitl = fit(xc',yc,'poly1');
        linCheck = fitl.p1;
        if gof.rsquare > 0.98 && linCheck>0
            % accept simple fit
            fits(r,:) = [fitp.p1 fitp.p2 nan gof.rsquare];
        else
            % use power-law fitting
            beta0 = [c(bx(xOnset,hs)) rand(1) xOnset]; % fitting start params
            try
                [fitp, gof] = fit(xnf',ynf','rat11','startpoint',beta0,'upper',[1,40,40],'lower',[0,0,0],'robust','LAR');
                fits(r,:) = [fitp.p1 fitp.p2 fitp.q1 gof.rsquare];
            catch ratFit1
                % use power-law fitting
                beta0 = [c(bx(xOnset,hs)) rand(1) rand(1)]; % fitting start params
                try
                    [fitp, gof] = fit(xnf',ynf','rat11','startpoint',beta0,'upper',[1,40,40],'lower',[0,0,0],'robust','LAR');
                    fits(r,:) = [fitp.p1 fitp.p2 fitp.q1 gof.rsquare];
                catch ratFit2
                    disp('failed fitting power-law2');
                    % revert to linear
                    disp('failed fitting power-law');
                    [fitp, gof] = fit(xnf',ynf','poly1');
                    %fits(r,:) = [fitp.p1 fitp.p2 nan gof.rsquare];
                    disp(r);
                    cftool(xnf,ynf);
                    pause
                end
            end
        end

        %plot(x,y,x,fitp(sqrt(x))); % check fit
        %title(strcat('Range:',num2str(ranges{r,6}),' = ',sprintf('%0.5f',gof.rsquare)));
        %pause
        % get fit:
        xc = x(end-15:end);
        cfitted = y'-fitp(x); % cumalative, BG subtracted
        yc = cfitted(end-15:end);
        fitl = fit(xc',yc,'poly1');
        linCheck = fitl.p1;
        if gof.rsquare < 0.9
            linCheck = -1;
        end
        offset = offset+1*binwidth; % move noise window backwards by 1 bins
        attempt = attempt+1;
    end
    plot(x,y'-fitp(x)); % check fit
    attempt
    if attempt==attemptLim
        %disp('select two points before the peak onset to fit BG');
        %points = ginput(2);
        points=1;
        if length(points)<2
            % delete this range
            disp('deleted');
        else
            x1=points(1,1)+xstart;
            x2=points(2,1)+xstart;
            xnf=centres(centres>=x1 & centres<=x2)-xstart;
            ynf=c(centres>=x1 & centres<=x2);
            disp(['range:' num2str(r)])
            %cftool(x,y);
            %pause
            % try fitting linear first
            [fitp, gof] = fit(xnf',ynf','poly1');
            if gof.rsquare > 0.98
                % accept simple fit
                %fits(r,:) = [fitp.p1 fitp.p2 nan gof.rsquare];
            else
                [fitp, gof] = fit(xnf',ynf','rat11','startpoint',beta0,'robust','LAR');
                fits(r,:) = [fitp.p1 fitp.p2 fitp.q1 gof.rsquare];
            end
            plot(x,y'-fitp(x)); % check fit
            %plot(x,y,x,fitp(sqrt(x))); % check fit
            reply=input('Is fit ok? y/n','s');
            if strcmpi(reply,'y')||isempty(reply)
                % keep
            else
                % discard
            end
        end
        %pause
    end
    % store onset for future ref:
    onsets(i)=centres(pkosI);
    % find range using peak area
    yr = y'-fitp(x);
    xr = x(x>=(centres(pkosI)-xstart))+xstart;
    yr = yr(x>=(centres(pkosI)-xstart));
    % normalise
    yr = (yr-min(yr))./max(yr-min(yr));
    [q,ia] = unique(yr); % remove duplicates
    ranges = rangeAssign(ranges,r,interp1(q,xr(ia),(0.5-level/2)),centres(xbin));
    ranges{r,6}=interp1(q,xr(ia),0.5);
    ranges = rangeAssign(ranges,r,interp1(q,xr(ia),(0.5+level/2)),centres(xbin));
end
% write new range file
% check for missing ranges
for r=1:range_num
   if isempty(ranges{r,5})
       ranges{r,5}=ranges{r,1};
   end
   if isempty(ranges{r,7})
       ranges{r,7}=ranges{r,2};
   end
end

if(1) % write new (rrng) range file
    % get file name, without extension
    newName = regexprep(rangeFile,'\.rrng','');
    newName = strcat(newName,'_A',num2str(level*100));
    exportRanges = cell(length(ranges(:,1)),(4+element_num));
    exportRanges(:,1) = ranges(:,5); % range start
    exportRanges(:,2) = ranges(:,7); % range end
    exportRanges(:,3:4) = ranges(:,3:4); % volume and colour
    % element-ion matrix
    exportRanges(:,5:(4+element_num)) = ranges(:,(end-element_num+1):end);
    % if there are miss matching ions and elements the above will fail
    %disp(exportRanges);
    newRrng = rangeWriter(exportRanges,elements,newName);
    disp(strcat('Wrote new rrng file:',newRrng));
end
%end