function [composition,elements]=rangeComposition(rangeFile)
%[composition,elements]=rangeComposition(rangeFile)
% *Crudely* estimate a composition using a range file (rrng) alone by
% assuming that (range width)/sqrt(m/z) is proportional to peak counts
% A London Feb 2015

% Read rrng file
if ischar(rangeFile)
    [element_num, range_num, elements, ranges] = rangeReader (rangeFile);
elseif length(rangeFile) == 5
    element_num = rangeFile{2};
    range_num   = rangeFile{3};
    elements    = rangeFile{4};
    ranges      = rangeFile{5};
    rangeFile   = rangeFile{1}; % set rangeFile = fileName
else
    [element_num, range_num, elements, ranges] = rangeReader (rangeFile);
end

% normalise based on sqrt(m/z)
rangeWidths = diff(cell2mat(ranges(:,1:2)),1,2);
% assume range counts = range width
rangeCounts = rangeWidths./sqrt(mean(cell2mat(ranges(:,1:2)),2));
composition = rangeCounts'*cell2mat(ranges(:,5:end));
composition = 100*composition./sum(composition);
[composition,ix]=sort(composition,'descend');
elements = elements(ix)';