function [rf,newPossibleIons]=rangeCheck(rangeFile,posFile, protectedPeaks, skipStart, ionRanges, possibleIons)
%[ranges]=rangeCheck(rangeFile,posFile, protectedPeaks, skipStart, peaks,rangeToPossibleIon)
% Decide if a range be present or add new ranges, also checks if the ions
% defined in 'overlaps' should be amended: if the range of a major isotope
% in overlaps is removed, then that ion from overlaps should be removed:
% Example: range 31.9-32.1 removed, therefore remove TiO++ and O2+ ions
% skipStart is the fraction of the start of the pos file to skip, 0.25 would
% skip the first quater of the file (for avoiding oxide layers).
% protectedPeaks is a matrix of peak centres that should not be deleted 
% even if they have few counts or are not above background (eg solute ions 
% from a cluster search)
% Only works with rrng files.
% possibleIons = {'Y',[2,3];'YO',[1,2];'Fe',[1,2];'Ti',1;} {ion [charge States]}
% overlaps = {cell}
% cell = {overlap1,overlap2,overlap3}
% overlap1 = {ion1,ion2,ion3}
% ion1 = {chargeState,element1,numberOfElement1,element2,numberOfElement2}
% Returns a cell array:
% rf = {rangeFile,element_num,range_num,elements,ranges};
% To write a new range file: rangeWriter(rf{5},rf{4},'newName.rrng');
plotting=1;
num_bins = 250000; % bins in the m/z spectrum
confInt = 0.1; %0.05 = 5% confidence inteval
minSignal = 10; % minimum total signal (counts) in a range
maxNoiseRangeWindows = 4;
minNoiseWindow = 0.2; % in Da
noiseGradLimit = 1E3; % no noise windows with a gradient > than this will be used
absNoiseMeanLimit = 0.5; % is the mean of the background-subtracked noise limit, higher numbers = accept more dubious fits

% load range ile
[element_num, range_num, elements, ranges] = rangeReader (rangeFile);

% temp vars
m1 = ones(size(ranges,1),2);

% sort ranges to make picking out overlaps easier
[~,indx]=sortrows(cell2mat(ranges(:,1)));
ranges = ranges(indx,:); % sorting
if skipStart==0
    % load masses
    [m]=loadMasses(posFile);
else
    fileInfo = dir(posFile);
    fileSize = fileInfo.bytes/16; % 4 floats, 4 bytes each
    [~,~,~,m]=readpospart(posFile,round(skipStart*fileSize),fileSize);
end
m(end+1) = 0;
m(end+1) = 250; % make sure max and min are set at 0 and 200 minimum
% plot histogram
[heights, centres]=hist(m,num_bins);
clear m
if plotting
    plot(centres,heights,'b-');
end
bw = centres(3)-centres(2); % bin width
nfit = zeros(maxNoiseRangeWindows,size(ranges,1));
sigmas = zeros(size(ranges,1),5);
rangesToKeep = zeros(size(ranges,1),1);
for r=1:size(ranges,1)
    % previous range end in Da:
    if r>1
        prevRange = ranges{r-1,2};
    else
        prevRange = 0;
    end
    % range width in Da
    rangeWidth = ranges{r,2} - ranges{r,1};
    % gap before the range in Da
    preRangeGap = min(maxNoiseRangeWindows*rangeWidth,ranges{r,1}-prevRange);
    preRangeGap = max(preRangeGap,minNoiseWindow); % set min width
    % find background regions, of which there are [maxNoiseRangeWindows]
    xpre1 = ranges{r,1}-(1:maxNoiseRangeWindows)*preRangeGap./maxNoiseRangeWindows; % starts
    xpre2 = ranges{r,1}-(0:(maxNoiseRangeWindows-1))*preRangeGap./maxNoiseRangeWindows; % ends
    %nfit=zeros(size(xpre1));
    
    for j=1:maxNoiseRangeWindows
        binStart = bx(xpre1(j),centres(1:2));
        binEnd = bx(xpre2(j),centres(1:2));
        % find the gradient of each pre-range window
        [nfitObj,gof] = fit(centres(binStart:binEnd)', heights(binStart:binEnd)','poly1');
        nfit(j,r) = nfitObj.p1; % gradient p2 = intercept
        %plot(centres(binStart:binEnd),nfitObj(centres(binStart:binEnd)),'r-');
        %text(mean(centres(binStart:binEnd)),mean(heights(binStart:binEnd)),num2str(nfit(j),3));
    end
    
    % discard anything with a large positive gradient
    % \/ is the full pre-range (with out discarding any parts
    preNoiseX = centres(bx(ranges{r,1}-preRangeGap,centres(1:2)):bx(ranges{r,1},centres(1:2)));
    preNoiseY = heights(bx(ranges{r,1}-preRangeGap,centres(1:2)):bx(ranges{r,1},centres(1:2)));
    a=ceil((preNoiseX-ranges{r,1}+preRangeGap).*maxNoiseRangeWindows./preRangeGap);
    a(a<1)=1;
    b = nfit(:,r)<noiseGradLimit; % remove some noise windows
    preNoiseX = preNoiseX(b(a)); % the actual cropping step
    preNoiseY = preNoiseY(b(a));
    rangeX = centres(bx(ranges{r,1},centres(1:2)):bx(ranges{r,2},centres(1:2)));
    rangeY = heights(bx(ranges{r,1},centres(1:2)):bx(ranges{r,2},centres(1:2)));
    % estimate back ground
    [expNoiseFit,~,~] = noiseFit(preNoiseX',preNoiseY',rangeX');
    % subtract background and get sdv and mean of pre-range region
    noiseMean = mean(preNoiseY'-expNoiseFit(preNoiseX.^2));
    noiseSDV  = std(preNoiseY'-expNoiseFit(preNoiseX.^2));
    signalMean = mean(rangeY'-expNoiseFit(rangeX.^2));
    % is noise normally distributed?
    if chi2test((rangeY'-expNoiseFit(rangeX.^2))',confInt)
       % chi2test == 1 then there is no peak here, mark it
       if plotting
           hold on
           plot(mean(rangeX),mean(rangeY)*2,'rd','MarkerFaceColor','r')
           m1(r,2)=0; % keep track
           hold off
       end
    else
       if plotting
           hold on
           plot(mean(rangeX),mean(rangeY)*2,'gd','MarkerFaceColor','g')
           hold off
       end
    end
    % check fitting, a large mean = bad fitting -> reduce noise window
    if abs(noiseMean)>absNoiseMeanLimit
        if plotting
            hold on
            %plot(mean(rangeX),mean(rangeY),'md','MarkerFaceColor','m')
            plot(preNoiseX,expNoiseFit(preNoiseX.^2),'m-');
            plot(rangeX,expNoiseFit(rangeX.^2),'m-.');
            hold off
        end
        % try fitting in half the pre-noise window
        preRangeGap = preRangeGap./2;
        preNoiseX = centres(bx(ranges{r,1}-preRangeGap,centres(1:2)):bx(ranges{r,1},centres(1:2)));
        preNoiseY = heights(bx(ranges{r,1}-preRangeGap,centres(1:2)):bx(ranges{r,1},centres(1:2)));
        [expNoiseFit,~,~] = noiseFit(preNoiseX',preNoiseY',rangeX');
        % subtract background and get sdv and mean of pre-range region
        noiseMeanNew = mean(preNoiseY'-expNoiseFit(preNoiseX.^2));
        %disp(abs(noiseMean));
        %disp(abs(noiseMeanNew));
        if abs(noiseMeanNew)<abs(noiseMean)
            % accept new fitting
            noiseMean = noiseMeanNew;
            noiseSDV  = std(preNoiseY'-expNoiseFit(preNoiseX.^2));
            signalMean = mean(rangeY'-expNoiseFit(rangeX.^2));
        end
        if plotting
            hold on
            plot(preNoiseX,expNoiseFit(preNoiseX.^2),'g-');
            plot(rangeX,expNoiseFit(rangeX.^2),'g-.');
            hold off
        end
    end
    % estimate signal-to-noise
    sigmas(r,1) = normpdf(signalMean,noiseMean,noiseSDV);
    sigmas(r,2) = noiseSDV;
    sigmas(r,3) = noiseMean;
    sigmas(r,4) = sum(rangeY);
    sigmas(r,5) = signalMean;
    % high-light possible non-ranges:
    if sigmas(r,1)>confInt && plotting
        hold on
        plot(mean(rangeX),mean(rangeY),'r^','MarkerFaceColor','r')
        plot(preNoiseX,expNoiseFit(preNoiseX.^2),'r-');
        plot(rangeX,expNoiseFit(rangeX.^2),'r-.');
        m1(r,1)=0;
        hold off
    elseif plotting
        hold on
        plot(mean(rangeX),mean(rangeY),'g^','MarkerFaceColor','g')
        plot(preNoiseX,expNoiseFit(preNoiseX.^2),'k-');
        plot(rangeX,expNoiseFit(rangeX.^2),'k-.');
        hold off
    end
    % keep ceterain ranges
    for j=1:length(protectedPeaks)
        if protectedPeaks(j) >=ranges{r,1} && protectedPeaks(j) <= ranges{r,2}
            rangesToKeep(r) = 1;
        end
    end
end
% sigmas = [p-value noiseSDV noiseMean integratedSignal]
rangesToRemove = [cell2mat(ranges(:,1)) sigmas];
p = (sigmas(:,1)>confInt | sigmas(:,4)<minSignal) & ~rangesToKeep; % which ranges to remove (logical)
rangesToRemove = rangesToRemove(p,:);
q = find(p);

if ~isempty(rangesToRemove)
    if isempty(ionRanges)
        [ionRanges]=associateIonsToRanges(ranges,elements,possibleIons);
    end
    disp(['Removing ranges:' rangeFile]);
    for i = 1:size(rangesToRemove,1)
        disp(strcat(num2str(rangesToRemove(i,1)),':',num2str(rangesToRemove(i,2)),', signal=',num2str(rangesToRemove(i,5),'%2.0f')));
        % remove ion from possible ions
        % is this the major isotope of this ion?
        % ion mass
        s = peakHeights(ionStr2ions(possibleIons(ionRanges(q(i),2),1)));
        ionMass = s(s(:,2)==max(s(:,2)),1);
        chargeState = round(mean(rangesToRemove(i,1:2))/ionMass);
        ionNum = ionRanges(q(i),2);
        if (ionMass/chargeState)>rangesToRemove(i,1) && (ionMass/chargeState)<ranges{cell2mat(ranges(:,1))==rangesToRemove(i,1),2} 
           % remove this ion charge state from the list of possible ions
           possibleIons{ionNum,4} = possibleIons{ionNum,4}(possibleIons{ionNum,4}~=chargeState);
        end
    end
end
% remove ions with empty charge states from possible ions
if sum(cell2mat(cellfun(@isempty,possibleIons(:,4),'uni',0)))
    disp('Removing ions:')
    disp(possibleIons(logical(cell2mat(cellfun(@isempty,possibleIons(:,4),'uni',0))),1));
    newPossibleIons = possibleIons(~logical(cell2mat(cellfun(@isempty,possibleIons(:,4),'uni',0))),:);
else
    newPossibleIons = possibleIons;
end
ranges = ranges(~p,:);% remove ranges
% remove missing elements
missingEle = sum(cell2mat(ranges(:,5:end)),1)==0;
ranges = ranges(:,logical([1 1 1 1 ~missingEle]));
elements = elements(~logical(missingEle));
range_num = size(ranges,1);
element_num = length(elements);
rf = {rangeFile,element_num,range_num,elements,ranges};
manualCheck = 0;
if manualCheck
    manPeak = zeros(size(ranges,1),1);
   for r=1:size(ranges,1)
       xlim([ranges{r,1}-0.1 ranges{r,2}+0.1]);
       ylim('auto');
       manPeak(r) = input('peak=1, no peak=0');
   end
end
end