function  [ranges]=rangeAssign(ranges,currentRange,value,centre)
%[ranges]=rangeAssign(ranges,currentRange,value)
% A very specific function only for rangeCorrector
% Assigns value as the upper or lower bound of range currentRange in the
% ranges cell (based upon the centre position of the range given by the
% average of the original range bounds (ranges{r,1}+ranges{r,2})
% Hardcoded elements: position of orignal ranges (cell) and the new range
% A London July 2014
% defined for the 'ranges' table, which column to use?
low0 = 1; % original lower range bounds column
high0 = 2;% original upper range bounds column
low1 = 5; % lower range bounds column
high1= 7; % upper range bounds column

r = currentRange;
if ~exist('centre','var')
    % centre given, assume it is the middle of the orignal ranges
   centre = (ranges{r,1}+ranges{r,2})/2;
end
% right or left?
upper = centre < value;
% make range table:
e=cell2mat(cellfun(@isempty,ranges(:,high1),'uni',0))|cell2mat(cellfun(@isempty,ranges(:,low1),'uni',0)); % missing new ranges
ranges2 = cell2mat(ranges(:,1:2));
% pick the widest ranges possible with min/max
for i = 1:size(ranges,1)
    if e(i) % no new range yet (use original)
        ranges2(i,1) = ranges{i,low0};
        ranges2(i,2) = ranges{i,high0};
    else % choose between original and new
        ranges2(i,1) = min(ranges{i,low0},ranges{i,low1});
        ranges2(i,2) = max(ranges{i,high0},ranges{i,high1});
    end
end
% check for an overlap
overlap = overlapCheck(ranges2,r,value);
if upper % right
    if ~overlap
        % no overlap
        ranges{r,high1} = value; % right
    else
        % overlaping, set limit as lower bound of overlapping
        % range
        ranges{r,high1} = ranges2(overlap,1);
        disp(strcat('*Overlap @:',sprintf('%6.2f',ranges2(overlap,1)),' *'));
    end
else %  lower, left
    if ~overlap
        % no overlap
        ranges{r,low1} = value; % left
    else
        % overlaping, set limit as upper bound of overlapping
        % range
        ranges{r,low1} = ranges2(overlap,2);
        disp(strcat('*Overlap @:',sprintf('%6.2f',ranges2(overlap,2)),' *'));
    end
end
end