function [x,y,z] = randsphere(n,r)
%[x,y,z] = randsphere(n,r)
% put n items randomly inside a sphere radius r

p = randn(n,3); % 3 columns of normally distributed pseudorandom numbers
d = 1./sqrt(sum(p.^2,2)); % distance of each point, p, from (0,0,0)
rr = r*(rand(n,1)).^(1/3); % random radial distance
x = rr.*d.*p(:,1);
y = rr.*d.*p(:,2);
z = rr.*d.*p(:,3);
end