function [r] = randDoubleExp(n,m,xscale)
% [n] = randDoubleExp(s)
% returns numbers from a double exponential distribution of the size n by m
% xscale stretches the width of the distribution
if nargin<3
    xscale = 1;
end
xmax = 10;
xstep = 0.1;

r = rand(n,m); % uniform random numbers
x = -xmax:xstep:xmax;
p = cumsum([exp(-xmax:xstep:-xstep) 1 exp(-xstep:-xstep:-xmax)]);
p = p./max(p);
r = interp1(p,(x+xstep/2).*(xscale*0.1),r,'linear','extrap');
end