% make the radiation-enhanced diffusion plot

% Create figure
figure1 = figure;
axes1 = axes('Parent',figure1);
displacementRate = 1E-3;
%k^2=4piRN :
% Lescoat 2014
r = 1.5E-9; % radius in nm
ND = 2.3E23; % ND in m-3
% FeTiY
r = 3E-9; % radius in nm
ND = 1E23; % ND in m-3
% FeCrTiY
% r = 2.1E-9; % radius in nm
% ND = 3.1E23; % ND in m-3

k2 = 4*pi*r*100*ND/1000000; % sink strength (using cm units)
Dm = 1E-18;
T=500:25:1200; 

semilogy(...
1./T,diffusionofTiinFe(vacancyCon(T,1E-3,4.3E11),T),'g-.',...
1./T,diffusionofYinFe(vacancyCon(T,1E-3,4.3E11),T),'b-.',...
1./T,diffusionofTiinFe(0,T),'g-',...
1./T,diffusionofYinFe(0,T),'b-'...
);legend('D^{Ti}_{irr}','D^{Y}_{irr}','D^{Ti}_{th}','D^Y_{th}')

title('FeTiY')

% set labels
xL = [1400 1073 973 873 773:-100:100];
ax = gca;
set(ax,'XTick',1./xL);
set(ax,'XTickLabel',cellfun(@num2str,num2cell(xL),'uni',0));

% Create xlabel
xlabel({'Temperature (K)'});

% Create ylabel
ylabel({'Diffusion Coefficient (cm^2s^{-1})'});

% vertical lines
ylims = get(gca,'ylim');  %Get x range 
hold on
plot([1/773 1/773],[ylims(1) ylims(2)],'LineStyle',':', 'Color',[.7 .7 .7])
plot([1/873 1/873],[ylims(1) ylims(2)],'LineStyle',':', 'Color',[.7 .7 .7])
plot([1/973 1/973],[ylims(1) ylims(2)],'LineStyle',':', 'Color',[.7 .7 .7])
hold off