% make the radiation-enhanced diffusion plot

% Create figure
figure1 = figure;
axes1 = axes('Parent',figure1);
Dm = 1E-18;
T = 100:10:1400;
%plot(1./T,log10(diffusionofYinFe(vacancyCon(T,1E-3,4.3E11),T)+Dm),'k-',1./T(T<600),log10(diffusionofYinFe(vacancyCon(T(T<600),1E-3,4.3E11),T(T<600))),'b-.',1./T(T<1200),log10(diffusionofYinFe(0,T(T<1200))),'r:')
semilogy(1./T,diffusionofYinFe(vacancyCon(T,1E-3,4.3E11),T)+Dm,'k-',1./T(T<600),diffusionofYinFe(vacancyCon(T(T<600),1E-3,4.3E11),T(T<600)),'b-.',1./T(T<1200),diffusionofYinFe(0,T(T<1200)),'r:')

% Create axes

%% Uncomment the following line to preserve the X-limits of the axes
xlim(axes1,[0.000572602346395144 0.00389175493058394]);
%% Uncomment the following line to preserve the Y-limits of the axes
ylim(axes1,[10^-21.4328295345937 10^-11.9484537752507]);

% Create xlabel
xlabel({'Temperature (K)'});

% Create ylabel
ylabel({'Diffusion Coefficient (cm^2s^{-1})'});

% Create textbox
annotation(figure1,'textbox',...
    [0.246488095238095 0.323785114267251 0.128571428571429 0.0676328502415459],...
    'String',{'Thermal'},...
    'EdgeColor','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.641130952380951 0.190934872721358 0.15 0.111111111111111],...
    'String',{'Radiation-','enhanced'},...
    'EdgeColor','none');

% Create textbox
annotation(figure1,'textbox',...
    [0.774702380952381 0.401756128760006 0.114285714285714 0.0676328502415459],...
    'String',{'Mixing'},...
    'EdgeColor','none');

xL = [1400 1000 700:-100:100];
ax = gca;
set(ax,'XTick',1./xL);
set(ax,'XTickLabel',cellfun(@num2str,num2cell(xL),'uni',0));
set(gca,'Position',[0.135714285714286,0.125766871165644,0.859523809523810,0.837423312883436]);