% proxygram fitter

proxFile = 'C:\Users\andy\APT\15529_prox69.csv';
% read file
data =  importdata(proxFile,',',1);
pos = data.data(:,1);
% fe only
%fe = data.data(:,2);
% Fe and Cr matrix
fe = data.data(:,2)+data.data(:,3);
counts = data.data(:,end);
% Check which way round the histogram is
if(counts(end)<counts(1))
      % flip data
    counts = flipud(counts);
    fe = flipud(fe);
    pos = -1.*flipud(pos);
end  

% plot
plot(pos,fe,pos,counts);
% get fitting regions
disp('Select the core part, then the start and finish of the matrix part');
[xx, yy] = ginput(3);
% convert to index space from data space
xx = round((xx-pos(1))./(pos(2)-pos(1)));
% fit first part
fun = @(beta,xdata) beta(1)*(xdata-beta(2)).^2;
disp('Core fitting...');
fit1 = lsqcurvefit(fun,[1 pos(1)],pos(1:xx(1)),counts(1:xx(1)));
% fit second part
disp('Matrix fitting...');
fit2 = lsqcurvefit(fun,[1 pos(1)],pos(xx(2):xx(3)),counts(xx(2):xx(3)));

%plot fitted curves
hold on
plot(pos,fun(fit1,pos),'r-.',pos,fun(fit2,pos),'c-.');
xlabel('Distance in nm');ylabel('Ion counts');
legend('Fe Counts','Total counts','Core fit','Matrix fit');
hold off
figure
plot(pos,fe-fun(fit2,pos));
xlabel('Distance in nm');ylabel('Ion counts');