% profilePlotterStack script
% run clusterProfile to generate zprofile first
% This plots the cluster z-profile one cluster at a time so you can see
% which clusters are important
s=0;
x=1:100;
for c = 1:count
    subplot(2,1,1) % left plot
    c1 = zprofile{c}(x,1:5);
    plot(x,c1(x,2)./sum(c1(x,:),2),'m',x,c1(x,3)./sum(c1(x,:),2),'b',x,c1(x,4)./sum(c1(x,:),2),'g',x,c1(x,5)./sum(c1(x,:),2),'r');
    legend('Cr','Y','Ti','O');
    xlabel({'100 points from - 4r_z to + 4r_z in Z-direction'});
    ylabel({'Elemental Fraction'});
    title('Total Elemental Fraction');
    % add Cr profile to stack
    s(x,c) =  c1(x,2)./sum(c1(x,:),2);
    subplot(2,1,2) % right plot
    bar(x,s./c,'stacked');
    xlim([0 100]);
    xlabel({'100 points from - 4r_z to + 4r_z in Z-direction'});
    ylabel({'Cr Fraction'});
    title('Running Average of Cr Fraction');
    disp(strcat(num2str(radii(c)),' nm, ',num2str(c)));
    pause
end