% profilePlotter script
% run clusterProfile to generate zprofile first

% crop by cluster radius:
%zprofile = zprofile(radii>2.3);
%count = sum(radii>2.3);
excludeClusters = [1,4,5];
crBulk = 0.11;
% elements to plot
e2p = {'Y','Ti','O','Cr'};
solutep = [1,2]; % which of the above are clustered
plotColours = {'b','g','r','m'};
% elements to plot positions
e2pp = zeros(1,length(e2p));
for i = 1:length(e2p)
e2pp(i) = find(strcmp(rangeElements,e2p{i}));
end
x=1:100;
% all counts:
c1 = zeros(size(zprofile{1})); % total counts
for j=1:count
    c2 = zprofile{j};
    %solute = sum(zprofile{i}(x,e2pp(solutep)),2);
    %c2 = profileCentre(solute,c2,x);
     if ~sum(j==excludeClusters)
        c1 = c1 + c2;
    end
end
subplot(2,2,1)
hold on
for i = 1:length(e2p)
    plot(x,c1(x,e2pp(i)),plotColours{i});
end
hold off
legend(e2p);
xlabel({strcat('100 points from - ',num2str(zs),'r_z to + ',num2str(zs),'r_z in Z-direction')});
ylabel({'Elemental Counts'});
title('Total counts');

subplot(2,2,2);
% total percentage
zcounts = sum(c1(x,:),2);
hold on
for i = 1:length(e2p)
    plot(x,c1(x,e2pp(i))./zcounts,plotColours{i});
end
hold off
legend(e2p);
xlabel({strcat('100 points from - ',num2str(zs),'r_z to + ',num2str(zs),'r_z in Z-direction')});
ylabel({'Elemental Fraction'});
title('Total Elemental Fraction');

subplot(2,2,3) % matrix corrected counts
FeCol = find(strcmp(elements,'Fe'));
c3 = c1;
c3(x,e2pp(4)) = c1(x,e2pp(4))-(c1(x,FeCol)*crBulk);
c3(c3<0) = 0; % remove negatives
c3(x,FeCol) = 0;
hold on
for i = 1:length(e2p)
    plot(x,c3(x,e2pp(i)),plotColours{i});
end
hold off
legend(e2p);
xlabel({strcat('100 points from - ',num2str(zs),'r_z to + ',num2str(zs),'r_z in Z-direction')});
ylabel({'Matrix Correct Elemental Counts'});
title('Total counts');

subplot(2,2,4); % matrix corrected percentage
zcounts = sum(c3(x,:),2);
hold on
for i = 1:length(e2p)
    plot(x,c3(x,e2pp(i))./zcounts,plotColours{i});
end
hold off
legend(e2p);
xlabel({strcat('100 points from - ',num2str(zs),'r_z to + ',num2str(zs),'r_z in Z-direction')});
ylabel({'Matrix Corrected Elemental Fraction'});
title('Total Elemental Fraction');