% profilePlotter script
% run clusterProfilerIonic to generate ziprofile first

% crop by cluster radius:
%ziprofile = ziprofile(radii<2.5);
%count = sum(radii<2.5);

for c = 1:length(zprofileCache(:,1));
ionq = zprofileCache{c,5};
ziprofile = zprofileCache{c,1};
count = length(ziprofile(:,1));
% identify ions
%pions = {'Cr','CrO','YO','Y','TiO','O','FeO'};
%pions = {'YO','Y','TiO','O','FeO'};
pions = {'YO','Y','O','O2','FeO'};
for i = 1:length(pions)
   pp(i) =  find(strcmp(ionq,pions(i))); % position of these ions in cols
end

% all counts:
c1 = ziprofile{1};
for j=2:count
    c1 = c1 + ziprofile{j};
end
subplot(2,1,1)
plot(x,c1(x,pp(1)));
hold all
for i=2:length(pions)
    plot(x,c1(x,pp(i)));
end
legend(pions);
xlabel({strcat('100 points from - ',num2str(zs),'extent_z to + ',num2str(zs),'extent_z in Z-direction')});
ylabel({'Ionic Counts'});
title('Total counts');
hold off

subplot(2,1,2);
% total percentage
plot(x,c1(x,pp(1))./sum(c1(x,:),2));
hold all
for i=2:length(pions)
    plot(x,c1(x,pp(i))./sum(c1(x,:),2));
end
legend(pions);
xlabel({strcat('100 points from - ',num2str(zs),'extent_z to + ',num2str(zs),'extent_z in Z-direction')});
ylabel({'Ionic Fraction'});
title('Total Ionic Fraction');
hold off
pause
end