% profilePlotter script
% run clusterProfile to generate zprofile first

% crop by cluster radius:
%zprofile = zprofile(radii>2.3);
%count = sum(radii>2.3);
excludeClusters = [1,4,5];

% elements to plot
e2p = {'Y','Ti','O','Cr','Fe'};
solutep = [1,2]; % which of the above are clustered
plotColours = {'b','g','r','m','k'};
% elements to plot positions
e2pp = zeros(1,length(e2p));
for i = 1:length(e2p)
e2pp(i) = find(strcmp(elements,e2p{i}));
end
x=1:100;
% all counts:
c1 = zeros(size(zprofile{1})); % total counts
for j=1:count
    c2 = zprofile{j};
    %solute = sum(zprofile{i}(x,e2pp(solutep)),2);
    %c2 = profileCentre(solute,c2,x);
     if ~sum(j==excludeClusters)
        c1 = c1 + c2;
    end
end
subplot(2,2,1)
hold on
for i = 1:length(e2p)
    plot(x,c1(x,e2pp(i)),plotColours{i});
end
hold off
legend(e2p);
xlabel({'100 points from - 4r_z to + 4r_z in Z-direction'});
ylabel({'Elemental Counts'});
title('Total counts');

subplot(2,2,2);
% total percentage
zcounts = sum(c1(x,:),2);
hold on
for i = 1:length(e2p)
    plot(x,c1(x,e2pp(i))./zcounts,plotColours{i});
end
hold off
legend(e2p);
xlabel({'100 points from - 4r_z to + 4r_z in Z-direction'});
ylabel({'Elemental Fraction'});
title('Total Elemental Fraction');

if(1)
subplot(2,2,3);
% elemental percentage in pulse direction
for j=1:count
    c1 = zprofile{j};
    profY(:,j) = (c1(x,3))./(sum(c1(x,:),2));
    profTi(:,j) = (c1(x,4))./(sum(c1(x,:),2));
    profO(:,j) = (c1(x,5))./(sum(c1(x,:),2));
    profCr(:,j) = (c1(x,2))./(sum(c1(x,:),2));
    profFe(:,j) = (c1(x,1))./(sum(c1(x,:),2));
end
profY(isnan(profY)) = 0;
profTi(isnan(profTi)) = 0;
profO(isnan(profO)) = 0;
profCr(isnan(profCr)) = 0;
profFe(isnan(profFe)) = 0;
plot(mean(profY,2));hold all;plot(mean(profTi,2));plot(mean(profO,2));plot(mean(profCr,2));plot(mean(profFe,2));hold off
legend('Y','Ti','O','Cr','Fe');
title('Average percentage, Z-direction');

subplot(2,2,4)
% percentage in pulse direction
for j=1:count
    c1 = zprofile{j};
    profY2(:,j) = (c1(100+x,3))./(sum(c1(100+x,:),2));
    profTi2(:,j) = (c1(100+x,4))./(sum(c1(100+x,:),2));
    profO2(:,j) = (c1(100+x,5))./(sum(c1(100+x,:),2));
    profCr2(:,j) = (c1(100+x,2))./(sum(c1(100+x,:),2));
end
profY2(isnan(profY2)) = 0;
profTi2(isnan(profTi2)) = 0;
profO2(isnan(profO2)) = 0;
profCr2(isnan(profCr2)) = 0;
plot(mean(profY2,2));hold all;plot(mean(profTi2,2));plot(mean(profO2,2));plot(mean(profCr2,2));hold off
legend('Y','Ti','O','Cr');
xlabel({'100 points from - 2r_g to + 2r_g in pulse sequence'});
ylabel({'Solute Percentage'});
title('Average percentage, pulse direction');

end