% Ionic line-profile plotter with mixed elemental/ionic data
% This is specificaly useful for looking at the Cr-shells of ODS particles
% as you don't want to show the whole range of ionic profiles but the 
% elemental ones with one or two ionic profiles too, eg Fe,Y,Ti,O,Cr,CrO
% You must have defined the ions to plot in 'e2p' in
% clusterProfileDataCompiler before you can plot them here.
% Run clusterProfileDecompIonic first to generate zprofileCache
% then clusterProfileDecompIonicPlot to check each cluster and generate an
% excludes list
% then run clusterProfileDataCompiler to stack all the data together and align
% the different ion columns
% It is possible to specify only a certain range of sizes to include using
% the sizeRange parameter eg [0 Inf].

if(1) % Cr setup
    plotColours = {'b-','g','r','m','m-.'};
    plotItems = {'Y','Ti','O','Cr','CrO'};
    plotType = {'e','e','e','e','i'}; % e = elemental, i = ionic
elseif 0 % Fe-Y-Ti setup
    plotColours = {'b-','g','r','k'};
    plotItems = {'Y','Ti','O','FeO'};
    plotType = {'e','e','e','i'}; % e = elemental, i = ionic
else % Yex
    plotColours = {'b-','r','k'};
    plotItems = {'Y','O','FeO'};
    plotType = {'e','e','i'}; % e = elemental, i = ionic
end

% if you define an ionic plot item then it's counts will be deducted from
% the appropriate elements (unless they are missing)
sizeRange = [0 Inf]; % size corpping
radii = cell2mat(profileData(:,3));
p = profileData(radii>=sizeRange(1) & radii<=sizeRange(2),:);
disp(strcat(num2str(length(p)), 'clusters included'));
% ionic average line profiles, ap = ionic counts
ap = zeros(size(profileData{1,4}));
for i = 1:size(p,1)
    ap = ap + p{i,4}; % sum all counts
end
% elemental comp, ep = elemental counts
ep = zeros(size(profileData{1,5}));
for i = 1:size(p,1)
    ep = ep + p{i,5};
end

% make composite data from elemental and ionic
pp = zeros(1,length(plotItems));
profileCounts = zeros(size(profileData{1,5},1),length(plotItems));
for i = 1:length(plotItems)
    if strcmp(plotType{i},'e') % elemental
        s = strcmp(plotItems{i},plottedElements);
        if sum(s)
            profileCounts(:,i) = profileCounts(:,i) + ep(:,s);
        else
            error(strcat('Missing element ',plotItems{i},' in plottedElements'));
        end
    elseif strcmp(plotType{i},'i') % ionic
        s = strcmp(plotItems{i},e2p);
        if sum(s)
            profileCounts(:,i) = ap(:,s);
            % now remove these counts from the appropriate elements
            [ionAmounts,targetEle] = ions2ionTable(ionStr2ions(plotItems{i}));
            for e = 1:length(targetEle)
                % find targetEle(e) in plotItems(strcmp(plotType,'e'))
                if sum(strcmp(targetEle{e},plotItems(strcmp(plotType,'e'))))
                    % remove ionAmounts from targetEle column
                    se = strcmp(targetEle{e},plotItems);
                    if sum(se)
                        profileCounts(:,se) = profileCounts(:,se) - ap(:,s)*ionAmounts(e);
                    else
                        error(strcat('Missing element ',targetEle{e},' in plottedElements'));
                    end
                else
                    % element not defined, so skip the deduction step
                end
            end
        else
            error(strcat('Missing ion ',plotItems{i},' in e2p, which is defined in clusterProfileDataCompiler'));
        end
    end
end
% plotting
cp = profileCounts./repmat(ap(:,end),[1 size(profileCounts,2)]);
plot(cp); legend(plotItems);title(strcat('Radius:',num2str(sizeRange(1)),'-',num2str(sizeRange(2)),' nm'));


