% Ionic line-profile plotter
% Run clusterProfileDecompIonic first to generate zprofileCache
% then clusterProfileDecompIonicPlot to check each cluster and generate an
% excludes list
% then run clusterProfileCompiler to stack all the data together and align
% the different ion columns
% It is possible to specify only a certain range of sizes to include using
% the sizeRange parameter eg [0 Inf].

plotColours = {'k','b-','b-.','r-','r-.','m'};
sizeRange = [0 4]; % size corpping
radii = cell2mat(profileData(:,3));
p = profileData(radii>=sizeRange(1) & radii<=sizeRange(2),:);
% average the line profiles
ap = zeros(size(profileData{1,4}));
for i = 1:size(p,1)
    ap = ap + p{i,4};
end
cp = ap(:,1:(end-1))./repmat(ap(:,end),[1 size(ap,2)-1]);
subplot(2,1,1); plot(cp); legend(e2p);

% % rough elemental comp
% [ionTable,e] = ions2ionTable(ionStr2ions(e2p)); % decomp table
% ep = ap(:,1:end-1)*ionTable; % elemental profile from the ions defined in e2p *not accurate!*
% cp = ep./repmat(sum(ep,2), [1 size(ep,2)]);
% subplot(2,1,2); plot(cp); legend(e);

% elemental comp
ep = zeros(size(profileData{1,5}));
for i = 1:size(p,1)
    ep = ep + p{i,5};
end
cp = ep(:,1:(end-1))./repmat(ep(:,end),[1 size(ep,2)-1]);
subplot(2,1,2); plot(cp); legend(plottedElements);
