% this script takes several Z-profiles and vertically concatonates them
% into a single simple data file. It uses ziprofile from
% clusterProfilerIonic and ionq (list of unique ions) to generate the data.
p=cell(3,1); i=cell(3,1);
% p{1} = c2_15065;
% p{2} = c2_15733;
% p{3} = c2_15783;
% 
% i{1} = ionq15065;
% i{2} = ionq15733;
% i{3} = ionq15783;

p{1} = c2_15734;
p{2} = c2_15867;
p{3} = c2_15868;
i{1} = ionq15734;
i{2} = ionq15867;
i{3} = ionq15868;
columnIons = {'Fe','Y','YO','TiO','O','FeO','Cr','CrO'};
data = zeros(100,length(columnIons));
for j = 1:3
    % loop through data
    for ion = 1:length(columnIons)
        data(:,ion) = data(:,ion) + p{j}(:,strcmp(i{j},columnIons(ion)));
    end
end