function [exportProfiles] = profileCompile(zprofiles,elementsList,groups,excludeList)
% ionic profile compiler (sums profiles together)
% sorts a list of elements and orders columns of a line profile
% You can group columns together using the groups input:
% {{'Y','YO','TiO'},{'Fe','Cr'},{'FeO'},{'CrO'}}
% Groups will be summed (eg Fe+Cr counts) above
ft = length(zprofiles(:,1)); % total number of analyses
% generate unique list of ions from elementsList
ions = unique(arrayfun(@(x) x{:}, [elementsList{:}], 'UniformOutput', false),'stable');
ug = unique(arrayfun(@(x) x{:}, [groups{:}], 'UniformOutput', false),'stable');
for i = 1:length(ug)
    if ~sum(strcmp(ug(i),ions))
        % check for ions from 'groups' in all ions in the profiles
        disp(strcat('Ion:',ug(i),' is in the group but not in the profile'));
        % this isn't actually too much of an issue, this column will be
        % zero
    end
end
x = length(zprofiles{1,1}{1,1}(:,1)); % length of each profile
gt = length(groups);
% Total Group1 Group2 Group3
exportProfiles = zeros(x,gt+1);
for f = 1:ft
    ht = length(elementsList{f});
    % remove exlcuded clusters' profiles:
    for i = 1:length(excludeList{f})
        zprofiles{f}{excludeList{f}(i)} = zeros(size(zprofiles{f}{ excludeList{f}(i) }));
    end
    ct = length(zprofiles{f}(:,1)); % tot num clusters
    % totals (per ion) =
    % reshape to x by ions by clusters
    % sum along dim2
    % reshape the result to a x by ions matrix
    
    totals=reshape((sum(reshape(cell2mat(zprofiles{f}),x,ct,[]),2)),x,[]);
    exportProfiles(:,1) = exportProfiles(:,1) + sum(totals,2); %total
    for g = 1:gt % loop through groups
        % find ions from group, sum them and add them to the total data
        cols = cell2mat(cellfun(@(x) sum(strcmp(x,groups{g})),elementsList{f},'UniformOutput',false));
        % add to exportProfiles
        try
        exportProfiles(:,g+1) = exportProfiles(:,g+1) + sum(totals(:,logical(cols)),2);
        catch
            disp(f);
            disp(size(exportProfiles));
            disp(g+1);
            disp(size(totals));
            disp(cols);
            error('poop');
        end
    end
end
disp(strcat(num2str(sum(cellfun(@length, zprofiles))-sum(cellfun(@length, excludeList))),' clusters total'));
end