function [centredProfile,offset]=profileCentre(centringProfile, offCentredProfile,x)
%[centredProfile]=profileCentre(centringProfile, offCentredProfile,x)
% using a line profile a different line profile is centred and returned, x
% are the points along the length of the profile
    csum = cumsum(centringProfile);
    [csumq,ia,~] = unique(csum);
    if length(csumq)>2
        centrePos = round(interp1(csumq,x(ia),csum(end)/2));
    else
        centrePos = median(x);
    end
    % shift profile
    offset = round(x(round(length(x)/2))-centrePos);
    centredProfile = circshift(offCentredProfile,[offset,0]);
    if centrePos>median(x)
        % set last values to 0
        centredProfile((end-offset):end,:) = 0;
    else
        % set first values to 0
        centredProfile(1:offset,:) = 0;
    end
end