% process line profiles from ivas

f = {'C:\Users\andy\APT\R14_18225\prof_lower.csv',...
    'C:\Users\andy\APT\R14_18225\prof_top.csv'};
types = {'Unirrd.','Irrd.'};
cellarrayTargets={'Fe','Cr','Y','Ti','O'};

% arrays to store the data
dists = cell(length(f),1);
pTemp = cell(length(f),1);
typesList = cell(length(f),1);

for i = 1:length(f)
    % read csv file
    [dists{i},percent,err,ions,ionCount,atomCount]=importIVASprofile(f{i});  
    % find target ions in read ions
    [l]=ismember(ions,cellarrayTargets);
    a = ions(l);
    [~,loc]=ismember(cellarrayTargets,a);
    
    % reorder the elements in the percent data
    pTemp1 = percent(:,l);
    pTemp{i} = pTemp1(:,loc);
    typesList{i} = repmat({types{i}},length(dists{i}),1);
end

% create output
export=[{'Dist'} cellarrayTargets {'Type'}];    
export = [export; num2cell([vertcat(dists{:}) vertcat(pTemp{:})]) vertcat(typesList{:})];
% save csv file
cell2csv('C010-LPs.csv',export);