function posgenOptionGen(xmlName,posFile,rrngFile,dmax,knn,dbulk,derode,nmin,core,statFile,relabel,clustered,unclustered,clusterIndex)
% creates an options.xml (xmlName) file for use with posgen
% function posgenOptionGen(xmlName,posFile,rrngFile,dmax,knn,dbulk,derode,...
% nmin,core,statFile,FLAGS:relabel,clustered,unclustered,clusterIndex)
% core = {'Y' 'YO' 'TiO' etc} possible ions produced by rrngFile to use as
% core ions in the cluster search.
% ONLY works with RRNG files, see rrngReader
% A London April 2013
% % *example values*
% all strings:
% xmlName = 'options.xml';
% posFile = 'POSFILE';
% rrngFile = 'r14_15065_10.rrng';
% dmax = 'DMAX'; % maximum separation distance (in nm)
% knn = '1' % minimum core ions withing dmax to count as clustered, >= 1
% dbulk = 'DBULK'; % aka envelope distance (in nm)
% derode = '0'; % erosion distance
% nmin = 'NMIN'; % '12'
% core = {'Y' 'YO' 'Ti' 'TiO' 'O' 'O2'}; % potential core ions
% Other/bulk/matrix ions are identified by taking a difference of the core
%   ions from the ions defined in the range file supplied.
% statFile = 'clusterStats.txt';
% % This assumes the range file has elements in  the correct order eg Fe:1
% % O:1 for FeO not OFe.
% Strings for outpout pos-files:
% clustered = 0; % 0 for none, string for pos output
% unclustered = 0; % 0 for none, string for pos output
% clusterIndex is a pos file with masses relabelled as cluster IDs
% clusterIndex = 'cluster.indexed'; % 0 for none string for pos output
% all logic
% relabel = 0; % randomising flag

% get all ions from rrng file using ionList
[element_num, range_num, elements, ranges] = rangeReader (rrngFile);
ions = ionList(ranges,elements);
% check core ions against list and produce coreList
coreList = ions(ismember(ions,core));
coreList = flipdim(coreList,2); % 'sorting'
% all remaining ions go in bulkList
bulkList = ions(logical(1-ismember(ions,core)));
bulkList = sort(bulkList); % sorting

if str2double(knn)>1 % if knn > 1 then use knn order parameter
    useKnn = '1';
else
    useKnn = '0'; % else disable this clustering step
end

% write options.xml
fid = fopen(xmlName,'w');
fprintf(fid,'%s\n','<!DOCTYPE posscript SYSTEM "posscript.dtd">');
fprintf(fid,'%s\n','<posscript>');
fprintf(fid,'\t%s\n','<version value="0.0.1"/>');
fprintf(fid,'\t%s\n',strcat('<posload file="',posFile,'"/>'));
if(relabel)
    fprintf(fid,'\t%s\n','<relabel/>');
end
fprintf(fid,'\t%s\n','<cluster>');
fprintf(fid,'\t\t%s\n','<algorithm value="maxsep">');
fprintf(fid,'\t\t\t%s\n',strcat('<dclassify value="',useKnn,'" knn="',knn,'"/> <!-- Coring (pre-cluster) dist; zero to disable this step-->'));
fprintf(fid,'\t\t\t%s\n',strcat('<dmax value="',dmax,'"/> <!-- Max sep dist -->'));
fprintf(fid,'\t\t\t%s\n',strcat('<dbulk value="',dbulk,'"/> <!-- AKA envelope-->'));
fprintf(fid,'\t\t\t%s\n',strcat('<derode value="',derode,'"/> <!-- erosion distance; zero to disbale this step-->'));
fprintf(fid,'\t\t%s\n','</algorithm>');
fprintf(fid,'\t\t%s\n',strcat('<range file="',rrngFile,'"/>'));
fprintf(fid,'\t\t%s\n','<!--select ions for cluster core (aka solute)-->');
fprintf(fid,'\t\t%s\n','<core>');
fprintf(fid,'\t\t\t%s\n','<typelist>');
for i = 1:length(coreList)
    fprintf(fid,'\t\t\t%s\n',strcat('<atomtype symbol="',coreList{i},'"/>'));
end
fprintf(fid,'\t\t\t%s\n','</typelist>');
fprintf(fid,'\t\t%s\n','</core>');
fprintf(fid,'\t\t%s\n','<!--select ions for bulk (aka matrix)-->');
fprintf(fid,'\t\t%s\n','<bulk>');
fprintf(fid,'\t\t\t%s\n','<typelist>');
for i = 1:length(bulkList)
    fprintf(fid,'\t\t\t\t%s\n',strcat('<atomtype symbol="',bulkList{i},'"/>'));
end
fprintf(fid,'\t\t\t%s\n','</typelist>');
fprintf(fid,'\t\t%s\n','</bulk>');
fprintf(fid,'\t\t%s\n',strcat('<sizeclip nmin="',nmin,'"/>'));
if ischar(statFile)
    fprintf(fid,'\t\t%s\n',strcat('<clusterstats core="true" bulk="true" percluster="true" file="',statFile,'"/>'));
end
if(clustered)
    fprintf(fid,'\t\t%s\n',strcat('<clustered-pos file="',clustered,'.pos" retain="true"/>'));
end
if(unclustered)
    fprintf(fid,'\t\t%s\n',strcat('<unclustered-pos file="',unclustered,'.pos" retain="true"/>'));
end
if(clusterIndex)
    fprintf(fid,'\t\t%s\n',strcat('<clusterid file="',clusterIndex,'.pos"/>'));
end
fprintf(fid,'\t%s\n','</cluster>');
fprintf(fid,'%s\n','</posscript>');
fclose(fid);
disp(strcat('Wrote:',xmlName));
end
