function [h]=posSlice(x,y,nb,sliceThickness,sequenceCentre)
%[plotHandle]=posSlice(x-pos,y-pos,numberOfIonsInPosFile,sliceThickness,sequenceCentre)
% sliceThickness = 0.3; % sequence length in %; 0.05 = 5%
% sequenceCentre = 0.5; % sequence centre in %
% 2D desorption map/density map from a slice in a pos file
% A. London  Oct 2014

% get pos name
%[posFile,posPath] = uigetfile('.pos');
%pFile = [posPath posFile];
% read pos file
%[x,y,z,m,nb]=readpos(pFile);

% generate slice histogram from the middle
histBins = 100;
sstart = round(nb*(sequenceCentre-sliceThickness/2)); sstart(sstart<=1)=1;
send = round(nb*(sequenceCentre+sliceThickness/2)); send(send>=nb)=nb;
n=hist3([x(sstart:send)' y(sstart:send)'],[histBins histBins]);
n1 = n'; 
n1( size(n,1) + 1 ,size(n,2) + 1 ) = 0; 

%Generate grid for 2-D projected view of intensities: 
xb = linspace(min(x(sstart:send)),max(x(sstart:send)),size(n,1)+1);
yb = linspace(min(y(sstart:send)),max(y(sstart:send)),size(n,1)+1);

%Make a pseudocolor plot: 
h = pcolor(xb,yb,n1);
set(h, 'EdgeColor', 'none'); % remove grid lines
axis equal
title([num2str(100*(sequenceCentre-sliceThickness/2)) '% to ' num2str(100*(sequenceCentre+sliceThickness/2)) '%']);
end