function str = plotmathBar(x,p)
%str = plotmathBar( x (int) , position integer)
% if x < 0 then returns bar(x) as a string, otherwise
% returns x as a string (num2str)
% If the position is set to:
% p = 0 bar(x)
% p = 1 *bar(x)
% p = 2 bar(x)*
% p = 3 *bar(x)*

if nargin<2
    p=0;
end

if x<0
    str = strcat('bar(',num2str(abs(x)),')');
    if p == 1
        str = strcat('*',str);
    elseif p == 2
        str = strcat(str,'*');
    elseif p == 3
        str = strcat('*',str,'*');
    end
else
    str = num2str(x);
end
end