% get points
[x,y,z,m,nb] = readpos('R14_16536-v01-planeCube');
%store points
points (:,1) = x';
points (:,2) = y';
points (:,3) = z';
% plot points
scatter3(x,y,z,'.')
pause on
pause
% fft ?
fft_points = fftn(points)
plot(fft_points);figure(gcf)
plot(points,'DisplayName','points','YDataSource','points');figure(gcf)
scatter3(fft_points(:,1),fft_points(:,2),fft_points(:,3),'.')

% transform points
points(:,3) = points(:,3) - min(points(:,3)
points(:,3) = points(:,3) - min(points(:,3))
points(:,3) = points(:,3) - 2.5
points(:,3) = points(:,3)/5
points(:,2) = points(:,2)/5
points(:,1) = points(:,1)/5
points(:,1) = points(:,1)-mean(points(:,1))
points(:,2) = points(:,2)-mean(points(:,2))
n = fitNormal(points,1); % use 'fitNormal' from web
pause
% find normal using PCA
[coeff,score,roots] = princomp(points);
basis = coeff(:,1:2)
normal = coeff(:,3)
[xgrid,ygrid] = meshgrid(linspace(min(points(:,1)),max(points(:,1)),5), ...
linspace(min(points(:,2)),max(points(:,2)),5));
zgrid = (1/normal(3)) .* (mean(points,1)*normal - (xgrid.*normal(1) + ygrid.*normal(2)));
h = mesh(xgrid,ygrid,zgrid,'EdgeColor',[0 0 0],'FaceAlpha',0);
norm_data = [mean(points); mean(points) + normal']
L=plot3(norm_data(:,1),norm_data(:,2),norm_data(:,3),'b-','LineWidth',3);
hold on
data = points;
L=plot3(data(:,1),data(:,2),data(:,3),'r.','Markerfacecolor','r'); % Plot the original data points
hold off